/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.policy.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PolicyAlternativeTest
extends AbstractBusClientServerTestBase {
    static final String PORT = PolicyAlternativeTest.allocatePort(Server.class);
    static final String PORT2 = PolicyAlternativeTest.allocatePort(Server.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public PolicyAlternativeTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        PolicyAlternativeTest.assertTrue((String)"Server failed to launch", (boolean)PolicyAlternativeTest.launchServer(Server.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        PolicyAlternativeTest.stopAllServers();
    }

    @Test
    public void testAsymmetric() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testNoSecurity() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItNoSecurityPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        try {
            utPort.doubleIt(25);
            PolicyAlternativeTest.fail((String)"Failure expected on no Security");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testUsernameToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItUsernameTokenPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testRequireClientCertToken() throws Exception {
        DoubleItPortType utPort;
        Bus bus;
        block3: {
            SpringBusFactory bf = new SpringBusFactory();
            URL busFile = PolicyAlternativeTest.class.getResource("client.xml");
            bus = bf.createBus(busFile.toString());
            SpringBusFactory.setDefaultBus((Bus)bus);
            SpringBusFactory.setThreadDefaultBus((Bus)bus);
            URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
            Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
            QName portQName = new QName(NAMESPACE, "DoubleItClientCertPort");
            utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
            this.updateAddressPort(utPort, PORT2);
            if (this.test.isStreaming()) {
                SecurityTestUtil.enableStreaming(utPort);
            }
            try {
                utPort.doubleIt(25);
                PolicyAlternativeTest.fail((String)"Failure expected because no client certificate");
            }
            catch (SOAPFaultException ex) {
                if (this.test.isStreaming()) break block3;
                PolicyAlternativeTest.assertTrue((boolean)ex.getMessage().contains("HttpsToken"));
            }
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportSupportingSigned() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportSupportingSignedPort");
        DoubleItPortType transportPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(transportPort, PORT2);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(transportPort);
        }
        try {
            transportPort.doubleIt(25);
            PolicyAlternativeTest.fail((String)"Failure expected on not signing a wsa header");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)transportPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportUTSupportingSigned() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportUTSupportingSignedPort");
        DoubleItPortType transportPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(transportPort, PORT2);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(transportPort);
        }
        try {
            transportPort.doubleIt(25);
            PolicyAlternativeTest.fail((String)"Failure expected on not signing a wsa header");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)transportPort).close();
        bus.shutdown(true);
    }
}

