/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml;

import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.rt.security.xacml.pdp.api.PolicyDecisionPoint;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.opensaml.Configuration;
import org.opensaml.xacml.XACMLObjectBuilder;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusCodeType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyDecisionPointMockImpl
implements PolicyDecisionPoint {
    public PolicyDecisionPointMockImpl() {
        OpenSAMLUtil.initSamlEngine();
    }

    public Source evaluate(Source request) {
        RequestType requestType = this.requestSourceToRequestType(request);
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        XACMLObjectBuilder responseTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(ResponseType.DEFAULT_ELEMENT_NAME);
        XACMLObjectBuilder resultTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(ResultType.DEFAULT_ELEMENT_NAME);
        XACMLObjectBuilder decisionTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(DecisionType.DEFAULT_ELEMENT_NAME);
        XACMLObjectBuilder statusTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(StatusType.DEFAULT_ELEMENT_NAME);
        XACMLObjectBuilder statusCodeTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(StatusCodeType.DEFAULT_ELEMENT_NAME);
        DecisionType decisionType = (DecisionType)decisionTypeBuilder.buildObject();
        String role = this.getSubjectRole(requestType);
        if ("manager".equals(role)) {
            decisionType.setDecision(DecisionType.DECISION.Permit);
        } else {
            decisionType.setDecision(DecisionType.DECISION.Deny);
        }
        ResultType result = (ResultType)resultTypeBuilder.buildObject();
        result.setDecision(decisionType);
        StatusType status = (StatusType)statusTypeBuilder.buildObject();
        StatusCodeType statusCode = (StatusCodeType)statusCodeTypeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:xacml:1.0:status:ok");
        status.setStatusCode(statusCode);
        result.setStatus(status);
        ResponseType response = (ResponseType)responseTypeBuilder.buildObject();
        response.setResult(result);
        return this.responseType2Source(response);
    }

    private RequestType requestSourceToRequestType(Source requestSource) {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            DOMResult res = new DOMResult();
            trans.transform(requestSource, res);
            Node nd = res.getNode();
            if (nd instanceof Document) {
                nd = ((Document)nd).getDocumentElement();
            }
            return (RequestType)OpenSAMLUtil.fromDom((Element)((Element)nd));
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting pdp response to ResponseType", e);
        }
    }

    private Source responseType2Source(ResponseType response) {
        Element responseElement;
        Document doc = DOMUtils.createDocument();
        try {
            responseElement = OpenSAMLUtil.toDom((XMLObject)response, (Document)doc);
        }
        catch (WSSecurityException e) {
            throw new RuntimeException("Error converting PDP RequestType to Dom", e);
        }
        return new DOMSource(responseElement);
    }

    private String getSubjectRole(RequestType request) {
        List subjects = request.getSubjects();
        if (subjects != null) {
            for (SubjectType subject : subjects) {
                List attributes = subject.getAttributes();
                if (attributes == null) continue;
                for (AttributeType attribute : attributes) {
                    if (!"urn:oasis:names:tc:xacml:2.0:subject:role".equals(attribute.getAttributeID())) continue;
                    return ((AttributeValueType)attribute.getAttributeValues().get(0)).getValue();
                }
            }
        }
        return null;
    }
}

