/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml;

import java.io.Closeable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.saml.Server;
import org.apache.cxf.systest.ws.saml.StaxServer;
import org.apache.cxf.systest.ws.saml.client.SamlCallbackHandler;
import org.apache.cxf.systest.ws.saml.client.SamlElementCallbackHandler;
import org.apache.cxf.systest.ws.saml.client.SamlRoleCallbackHandler;
import org.apache.cxf.systest.ws.ut.SecurityHeaderCacheInterceptor;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.wss4j.common.saml.bean.AudienceRestrictionBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SamlTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = SamlTokenTest.allocatePort(Server.class);
    static final String STAX_PORT = SamlTokenTest.allocatePort(StaxServer.class);
    static final String PORT2 = SamlTokenTest.allocatePort(Server.class, (int)2);
    static final String STAX_PORT2 = SamlTokenTest.allocatePort(StaxServer.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public SamlTokenTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        SamlTokenTest.assertTrue((String)"Server failed to launch", (boolean)SamlTokenTest.launchServer(Server.class, (boolean)true));
        SamlTokenTest.assertTrue((String)"Server failed to launch", (boolean)SamlTokenTest.launchServer(StaxServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        SamlTokenTest.stopAllServers();
    }

    @Test
    public void testSaml1OverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1TransportPort");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml1Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml1Port);
        }
        try {
            saml1Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        try {
            saml1Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML2 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((ex.getMessage().contains("Wrong SAML Version") || ex.getMessage().contains("enforces SamlVersion11Profile11 but we got 2.0") ? 1 : 0) != 0);
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        portQName = new QName(NAMESPACE, "DoubleItSaml1TransportPort2");
        saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml1Port, PORT2);
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        try {
            saml1Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected on no token");
        }
        catch (SOAPFaultException ex) {
            String error = "The received token does not match the token inclusion requirement";
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)saml1Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml1Supporting() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1SupportingPort");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml1Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml1Port);
        }
        SamlCallbackHandler samlCallbackHandler = new SamlCallbackHandler(false, true);
        samlCallbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", samlCallbackHandler);
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml1Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml1SupportingSelfSigned() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1SupportingPort");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml1Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml1Port);
        }
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(false, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.signature.username", "alice");
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.signature.properties", "alice.properties");
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.callback-handler", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml1Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml1ElementOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1TransportPort");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml1Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml1Port);
        }
        try {
            saml1Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlElementCallbackHandler(false));
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml1Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2OverSymmetric() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2SymmetricPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML1 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((ex.getMessage().contains("Wrong SAML Version") || ex.getMessage().contains("enforces SamlVersion20Profile11 but we got 1.1") ? 1 : 0) != 0);
        }
        SamlCallbackHandler samlCallbackHandler = new SamlCallbackHandler();
        samlCallbackHandler.setSignAssertion(true);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", samlCallbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2OverSymmetricSupporting() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2SymmetricSupportingPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with an unsigned SAML SV Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((ex.getMessage().contains("SamlToken not satisfied") || ex.getMessage().equals("A security error was encountered when verifying the message") ? 1 : 0) != 0);
        }
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2OverAsymmetric() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2AsymmetricPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML1 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((ex.getMessage().contains("Wrong SAML Version") || ex.getMessage().contains("enforces SamlVersion20Profile11 but we got 1.1") ? 1 : 0) != 0);
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        portQName = new QName(NAMESPACE, "DoubleItSaml2AsymmetricPort2");
        saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected on no token");
        }
        catch (SOAPFaultException ex) {
            String error = "The received token does not match the token inclusion requirement";
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml1SelfSignedOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1SelfSignedTransportPort");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml1Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml1Port);
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false, true));
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml1Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml1SelfSignedOverTransportSP11() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1SelfSignedTransportSP11Port");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml1Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml1Port);
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false, true));
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml1Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricSamlInitiator() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricSamlInitiatorPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2OverSymmetricSignedElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2SymmetricSignedElementsPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        if (!this.test.isStreaming() && PORT.equals(this.test.getPort())) {
            SamlCallbackHandler samlCallbackHandler = new SamlCallbackHandler();
            ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", samlCallbackHandler);
            int result = saml2Port.doubleIt(25);
            SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        }
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2EndorsingOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2EndorsingTransportPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2EndorsingPKOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2EndorsingTransportPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setKeyInfoIdentifier(KeyInfoBean.CERT_IDENTIFIER.KEY_VALUE);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2EndorsingOverTransportSP11() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2EndorsingTransportSP11Port");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2OverAsymmetricSignedEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2AsymmetricSignedEncryptedPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2OverAsymmetricSignedEncryptedEncryptBeforeSigning() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2AsymmetricSignedEncryptedEncryptBeforeSigningPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        if (!this.test.isStreaming() && PORT.equals(this.test.getPort())) {
            ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
            int result = saml2Port.doubleIt(25);
            SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        }
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2OverAsymmetricEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2AsymmetricEncryptedPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2EndorsingEncryptedOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2EndorsingEncryptedTransportPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testNoSamlToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItInlinePolicyPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(saml2Port);
        }
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected on no SamlToken");
        }
        catch (SOAPFaultException ex) {
            String error = "The received token does not match the token inclusion requirement";
            SamlTokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("SamlToken not satisfied") ? 1 : 0) != 0);
        }
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2PEP() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2PEPPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, this.test.getPort());
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected as Assertion doesn't contain Role information");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        SamlRoleCallbackHandler roleCallbackHandler = new SamlRoleCallbackHandler();
        roleCallbackHandler.setSignAssertion(true);
        roleCallbackHandler.setRoleName("manager");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", roleCallbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        roleCallbackHandler.setRoleName("boss");
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected as Assertion doesn't contain correct role");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSaml2Replay() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        Client cxfClient = ClientProxy.getClient((Object)saml2Port);
        SecurityHeaderCacheInterceptor cacheInterceptor = new SecurityHeaderCacheInterceptor();
        cxfClient.getOutInterceptors().add(cacheInterceptor);
        saml2Port.doubleIt(25);
        saml2Port.doubleIt(25);
        ConditionsBean conditions = new ConditionsBean();
        conditions.setTokenPeriodMinutes(5);
        conditions.setOneTimeUse(true);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConditions(conditions);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        cxfClient.getOutInterceptors().remove(cacheInterceptor);
        cacheInterceptor = new SecurityHeaderCacheInterceptor();
        cxfClient.getOutInterceptors().add(cacheInterceptor);
        saml2Port.doubleIt(25);
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected on a replayed SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("A security error was encountered when verifying the message"));
        }
        ((Closeable)saml2Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAudienceRestriction() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort2");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        ConditionsBean conditions = new ConditionsBean();
        ArrayList<AudienceRestrictionBean> audienceRestrictions = new ArrayList<AudienceRestrictionBean>();
        AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
        audienceRestriction.setAudienceURIs(Collections.singletonList("https://localhost:" + portNumber + "/DoubleItSaml2Transport2"));
        audienceRestrictions.add(audienceRestriction);
        conditions.setAudienceRestrictions(audienceRestrictions);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConditions(conditions);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        saml2Port.doubleIt(25);
        try {
            audienceRestriction = new AudienceRestrictionBean();
            audienceRestriction.setAudienceURIs(Collections.singletonList("https://localhost:" + portNumber + "/DoubleItSaml2Transport2unknown"));
            audienceRestrictions.clear();
            audienceRestrictions.add(audienceRestriction);
            conditions.setAudienceRestrictions(audienceRestrictions);
            callbackHandler.setConditions(conditions);
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected on unknown AudienceRestriction");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
    }

    @Test
    public void testAudienceRestrictionServiceName() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort2");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        ConditionsBean conditions = new ConditionsBean();
        ArrayList<AudienceRestrictionBean> audienceRestrictions = new ArrayList<AudienceRestrictionBean>();
        AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
        audienceRestriction.setAudienceURIs(Collections.singletonList(service.getServiceName().toString()));
        audienceRestrictions.add(audienceRestriction);
        conditions.setAudienceRestrictions(audienceRestrictions);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConditions(conditions);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        saml2Port.doubleIt(25);
    }

    @Test
    public void testDisableAudienceRestrictionValidation() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort2");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String portNumber = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            portNumber = STAX_PORT2;
        }
        this.updateAddressPort(saml2Port, portNumber);
        ConditionsBean conditions = new ConditionsBean();
        ArrayList<AudienceRestrictionBean> audienceRestrictions = new ArrayList<AudienceRestrictionBean>();
        AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
        audienceRestriction.setAudienceURIs(Collections.singletonList(service.getServiceName().toString() + ".xyz"));
        audienceRestrictions.add(audienceRestriction);
        conditions.setAudienceRestrictions(audienceRestrictions);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConditions(conditions);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected on unknown AudienceRestriction");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort3");
        saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, portNumber);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        saml2Port.doubleIt(25);
    }
}

