/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml.subjectconf;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.saml.client.SamlCallbackHandler;
import org.apache.cxf.systest.ws.saml.subjectconf.Server;
import org.apache.cxf.systest.ws.saml.subjectconf.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SamlSubjectConfTest
extends AbstractBusClientServerTestBase {
    static final String PORT = SamlSubjectConfTest.allocatePort(Server.class);
    static final String STAX_PORT = SamlSubjectConfTest.allocatePort(StaxServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public SamlSubjectConfTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        SamlSubjectConfTest.assertTrue((String)"Server failed to launch", (boolean)SamlSubjectConfTest.launchServer(Server.class, (boolean)true));
        SamlSubjectConfTest.assertTrue((String)"Server failed to launch", (boolean)SamlSubjectConfTest.launchServer(StaxServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(STAX_PORT, false)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        SamlSubjectConfTest.stopAllServers();
    }

    @Test
    public void testHOKClientAuthentication() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setCryptoAlias("morpit");
        callbackHandler.setCryptoPassword("password");
        callbackHandler.setCryptoPropertiesFile("morpit.properties");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = port.doubleIt(25);
        SamlSubjectConfTest.assertTrue((result == 50 ? 1 : 0) != 0);
        callbackHandler = new SamlCallbackHandler(true, false);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setCryptoAlias("morpit");
        callbackHandler.setCryptoPassword("password");
        callbackHandler.setCryptoPropertiesFile("morpit.properties");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on a unsigned assertion");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testHOKNonMatchingCert() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on a non matching cert (SAML -> TLS)");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testHOKNoClientAuthentication() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-noauth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setCryptoAlias("morpit");
        callbackHandler.setCryptoPassword("password");
        callbackHandler.setCryptoPropertiesFile("morpit.properties");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on no client auth");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSVClientAuthentication() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, false);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = port.doubleIt(25);
        SamlSubjectConfTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSVNoClientAuthentication() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-noauth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, false);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on no client auth");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testBearer() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        callbackHandler.setCryptoAlias("morpit");
        callbackHandler.setCryptoPassword("password");
        callbackHandler.setCryptoPropertiesFile("morpit.properties");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = port.doubleIt(25);
        SamlSubjectConfTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testUnsignedBearer() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, false);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on an unsigned bearer token");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testUnknownCustomMethod() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true, false);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:custom");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on an unknown custom subject confirmation method");
        }
        catch (SOAPFaultException sOAPFaultException) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

