/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.swa;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.swa.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItSwaPortType;
import org.example.schema.doubleit.DoubleIt3;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SWAActionTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = SWAActionTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        SWAActionTest.assertTrue((String)"Server failed to launch", (boolean)SWAActionTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        SWAActionTest.stopAllServers();
    }

    @Test
    public void testSWASignatureContentAction() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAActionTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAActionTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWASignatureContentActionPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, PORT);
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSWASignatureCompleteAction() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAActionTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAActionTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWASignatureCompleteActionPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, PORT);
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSWAEncryptionContentAction() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAActionTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAActionTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWAEncryptionContentActionPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, PORT);
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSWAEncryptionCompleteAction() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAActionTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAActionTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWAEncryptionCompleteActionPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, PORT);
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

