/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.swa;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.swa.PolicyServer;
import org.apache.cxf.systest.ws.swa.StaxPolicyServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItSwaPortType;
import org.example.schema.doubleit.DoubleIt3;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SWAPolicyTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = SWAPolicyTest.allocatePort(PolicyServer.class);
    public static final String STAX_PORT = SWAPolicyTest.allocatePort(StaxPolicyServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public SWAPolicyTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        SWAPolicyTest.assertTrue((String)"Server failed to launch", (boolean)SWAPolicyTest.launchServer(PolicyServer.class, (boolean)true));
        SWAPolicyTest.assertTrue((String)"Server failed to launch", (boolean)SWAPolicyTest.launchServer(StaxPolicyServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        SWAPolicyTest.stopAllServers();
    }

    @Test
    public void testSWASignatureContentPolicy() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAPolicyTest.class.getResource("policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAPolicyTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWASignatureContentPolicyPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SWAPolicyTest.enableStreaming(port);
        }
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSWASignatureCompletePolicy() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAPolicyTest.class.getResource("policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAPolicyTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWASignatureCompletePolicyPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SWAPolicyTest.enableStreaming(port);
        }
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSWAEncryptionPolicy() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAPolicyTest.class.getResource("policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAPolicyTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWAEncryptionPolicyPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SWAPolicyTest.enableStreaming(port);
        }
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSWACombinedPolicy() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAPolicyTest.class.getResource("policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAPolicyTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWACombinedPolicyPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SWAPolicyTest.enableStreaming(port);
        }
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSWACombinedAsymmetricPolicy() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SWAPolicyTest.class.getResource("policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SWAPolicyTest.class.getResource("DoubleItSwa.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSWACombinedAsymmetricPolicyPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SWAPolicyTest.enableStreaming(port);
        }
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    static void enableStreaming(DoubleItSwaPortType port) {
        ((BindingProvider)port).getRequestContext().put("ws-security.enable.streaming", "true");
        ((BindingProvider)port).getResponseContext().put("ws-security.enable.streaming", "true");
    }
}

