/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.ut;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SimpleGroup;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.UsernameTokenValidator;

public class CustomUTValidator
extends UsernameTokenValidator {
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        Credential cred = super.validate(credential, data);
        UsernameToken ut = credential.getUsernametoken();
        WSUsernameTokenPrincipalImpl principal = new WSUsernameTokenPrincipalImpl(ut.getName(), ut.isHashed());
        principal.setCreatedTime(ut.getCreated());
        principal.setNonce(principal.getNonce());
        principal.setPassword(ut.getPassword());
        principal.setPasswordType(ut.getPasswordType());
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)principal);
        if ("Alice".equals(ut.getName())) {
            subject.getPrincipals().add((Principal)new SimpleGroup("manager", ut.getName()));
        }
        subject.getPrincipals().add((Principal)new SimpleGroup("worker", ut.getName()));
        cred.setSubject(subject);
        return cred;
    }
}

