/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.ut;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.ut.SecurityHeaderCacheInterceptor;
import org.apache.cxf.systest.ws.ut.Server;
import org.apache.cxf.systest.ws.ut.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UsernameTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = UsernameTokenTest.allocatePort(Server.class);
    static final String STAX_PORT = UsernameTokenTest.allocatePort(StaxServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public UsernameTokenTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        UsernameTokenTest.assertTrue((String)"Server failed to launch", (boolean)UsernameTokenTest.launchServer(Server.class, (boolean)true));
        UsernameTokenTest.assertTrue((String)"Server failed to launch", (boolean)UsernameTokenTest.launchServer(StaxServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        UsernameTokenTest.stopAllServers();
    }

    @Test
    public void testPlaintext() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPlaintextPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testPlaintextCreated() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPlaintextCreatedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testPlaintextSupporting() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPlaintextSupportingPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testPasswordHashed() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItHashedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testNoPassword() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItNoPasswordPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEndorsingPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testNoUsernameToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItInlinePolicyPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        try {
            utPort.doubleIt(25);
            UsernameTokenTest.fail((String)"Failure expected on no UsernameToken");
        }
        catch (SOAPFaultException ex) {
            String error = "The received token does not match the token inclusion requirement";
            UsernameTokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("UsernameToken not satisfied") ? 1 : 0) != 0);
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testPasswordHashedReplay() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItHashedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (!this.test.isStreaming()) {
            Client cxfClient = ClientProxy.getClient((Object)utPort);
            SecurityHeaderCacheInterceptor cacheInterceptor = new SecurityHeaderCacheInterceptor();
            cxfClient.getOutInterceptors().add(cacheInterceptor);
            utPort.doubleIt(25);
            try {
                utPort.doubleIt(25);
                UsernameTokenTest.fail((String)"Failure expected on a replayed UsernameToken");
            }
            catch (SOAPFaultException ex) {
                UsernameTokenTest.assertTrue((boolean)ex.getMessage().contains("A security error was encountered when verifying the message"));
            }
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testPasswordHashedNoBindingReplay() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItDigestNoBindingPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (!this.test.isStreaming() && PORT.equals(this.test.getPort())) {
            Client cxfClient = ClientProxy.getClient((Object)utPort);
            SecurityHeaderCacheInterceptor cacheInterceptor = new SecurityHeaderCacheInterceptor();
            cxfClient.getOutInterceptors().add(cacheInterceptor);
            utPort.doubleIt(25);
            try {
                utPort.doubleIt(25);
                UsernameTokenTest.fail((String)"Failure expected on a replayed UsernameToken");
            }
            catch (SOAPFaultException ex) {
                UsernameTokenTest.assertTrue((boolean)ex.getMessage().equals("A security error was encountered when verifying the message"));
            }
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testPlaintextPrincipal() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPlaintextPrincipalPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(utPort);
        }
        ((BindingProvider)utPort).getRequestContext().put("ws-security.username", "Alice");
        utPort.doubleIt(25);
        try {
            ((BindingProvider)utPort).getRequestContext().put("ws-security.username", "Frank");
            utPort.doubleIt(30);
            UsernameTokenTest.fail((String)"Failure expected on a user with the wrong role");
        }
        catch (SOAPFaultException ex) {
            String error = "Unauthorized";
            UsernameTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }
}

