/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssc;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.KeystorePasswordCallback;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.wssc.UnitServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.DefaultSymmetricBinding;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.ProtectionToken;
import org.apache.wss4j.policy.model.SignedParts;
import org.apache.wss4j.policy.model.X509Token;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WSSCUnitTest
extends AbstractBusClientServerTestBase {
    static final String PORT = WSSCUnitTest.allocatePort(UnitServer.class);
    static final String PORT2 = WSSCUnitTest.allocatePort(UnitServer.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public WSSCUnitTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSSCUnitTest.assertTrue((String)"Server failed to launch", (boolean)WSSCUnitTest.launchServer(UnitServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSCUnitTest.stopAllServers();
    }

    @Test
    public void testEndorsingSecureConveration() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = WSSCUnitTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = WSSCUnitTest.class.getResource("DoubleItWSSC.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
    }

    @Test
    public void testEndorsingSecureConverationSP12() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = WSSCUnitTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = WSSCUnitTest.class.getResource("DoubleItWSSC.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportSP12Port");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
    }

    @Test
    public void testIssueUnitTest() throws Exception {
        if (this.test.isStreaming()) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = WSSCUnitTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        STSClient stsClient = new STSClient(bus);
        stsClient.setSecureConv(true);
        stsClient.setLocation("https://localhost:" + PORT + "/" + "DoubleItTransport");
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        All all = new All();
        all.addPolicyComponent((PolicyComponent)new PrimitiveAssertion(MetadataConstants.USING_ADDRESSING_2006_QNAME, false));
        ea.addPolicyComponent((PolicyComponent)all);
        stsClient.setPolicy((Object)p);
        stsClient.requestSecurityToken("http://localhost:" + PORT + "/" + "DoubleItTransport");
    }

    @Test
    public void testIssueAndCancelUnitTest() throws Exception {
        if (this.test.isStreaming()) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = WSSCUnitTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        STSClient stsClient = new STSClient(bus);
        stsClient.setSecureConv(true);
        stsClient.setLocation("http://localhost:" + PORT2 + "/" + "DoubleItSymmetric");
        stsClient.setPolicy((Object)this.createSymmetricBindingPolicy());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("ws-security.encryption.username", "bob");
        TokenCallbackHandler callbackHandler = new TokenCallbackHandler();
        properties.put("ws-security.callback-handler", callbackHandler);
        properties.put("ws-security.signature.properties", "alice.properties");
        properties.put("ws-security.encryption.properties", "bob.properties");
        stsClient.setProperties(properties);
        SecurityToken securityToken = stsClient.requestSecurityToken("http://localhost:" + PORT2 + "/" + "DoubleItSymmetric");
        WSSCUnitTest.assertNotNull((Object)securityToken);
        callbackHandler.setSecurityToken(securityToken);
        WSSCUnitTest.assertTrue((boolean)stsClient.cancelSecurityToken(securityToken));
    }

    private Policy createSymmetricBindingPolicy() {
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        All all = new All();
        all.addPolicyComponent((PolicyComponent)new PrimitiveAssertion(MetadataConstants.USING_ADDRESSING_2006_QNAME, false));
        ea.addPolicyComponent((PolicyComponent)all);
        X509Token x509Token = new X509Token(SPConstants.SPVersion.SP12, SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER, null, null, null, new Policy());
        Policy x509Policy = new Policy();
        ExactlyOne x509PolicyEa = new ExactlyOne();
        x509Policy.addPolicyComponent((PolicyComponent)x509PolicyEa);
        All x509PolicyAll = new All();
        x509PolicyAll.addPolicyComponent((PolicyComponent)x509Token);
        x509PolicyEa.addPolicyComponent((PolicyComponent)x509PolicyAll);
        Policy algSuitePolicy = new Policy();
        ExactlyOne algSuitePolicyEa = new ExactlyOne();
        algSuitePolicy.addPolicyComponent((PolicyComponent)algSuitePolicyEa);
        All algSuitePolicyAll = new All();
        algSuitePolicyAll.addAssertion((Assertion)new PrimitiveAssertion(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Basic128")));
        algSuitePolicyEa.addPolicyComponent((PolicyComponent)algSuitePolicyAll);
        AlgorithmSuite algorithmSuite = new AlgorithmSuite(SPConstants.SPVersion.SP12, algSuitePolicy);
        Policy bindingPolicy = new Policy();
        ExactlyOne bindingPolicyEa = new ExactlyOne();
        bindingPolicy.addPolicyComponent((PolicyComponent)bindingPolicyEa);
        All bindingPolicyAll = new All();
        bindingPolicyAll.addPolicyComponent((PolicyComponent)new ProtectionToken(SPConstants.SPVersion.SP12, x509Policy));
        bindingPolicyAll.addPolicyComponent((PolicyComponent)algorithmSuite);
        bindingPolicyAll.addAssertion((Assertion)new PrimitiveAssertion(SP12Constants.INCLUDE_TIMESTAMP));
        bindingPolicyAll.addAssertion((Assertion)new PrimitiveAssertion(SP12Constants.ONLY_SIGN_ENTIRE_HEADERS_AND_BODY));
        bindingPolicyEa.addPolicyComponent((PolicyComponent)bindingPolicyAll);
        DefaultSymmetricBinding binding = new DefaultSymmetricBinding(SPConstants.SPVersion.SP12, bindingPolicy);
        binding.setOnlySignEntireHeadersAndBody(true);
        binding.setProtectTokens(false);
        all.addPolicyComponent((PolicyComponent)binding);
        ArrayList headers = new ArrayList();
        SignedParts signedParts = new SignedParts(SPConstants.SPVersion.SP12, true, null, headers, false);
        all.addPolicyComponent((PolicyComponent)signedParts);
        return p;
    }

    private static class TokenCallbackHandler
    implements CallbackHandler {
        private SecurityToken securityToken;

        private TokenCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                if (this.securityToken != null && pc.getIdentifier().equals(this.securityToken.getId())) {
                    pc.setKey(this.securityToken.getSecret());
                    continue;
                }
                new KeystorePasswordCallback().handle(callbacks);
            }
        }

        public void setSecurityToken(SecurityToken securityToken) {
            this.securityToken = securityToken;
        }
    }
}

