/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec11;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssec11.WSSecurity11Common;
import org.apache.cxf.systest.ws.wssec11.server.Server12;
import org.apache.cxf.systest.ws.wssec11.server.Server12Restricted;
import org.apache.cxf.systest.ws.wssec11.server.StaxServer12;
import org.apache.cxf.systest.ws.wssec11.server.StaxServer12Restricted;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WSSecurity112Test
extends WSSecurity11Common {
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();
    final TestParam test;

    public WSSecurity112Test(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        if (unrestrictedPoliciesInstalled) {
            WSSecurity112Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity112Test.launchServer(Server12.class, (boolean)true));
            WSSecurity112Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity112Test.launchServer(StaxServer12.class, (boolean)true));
        } else {
            if (WSSecurity11Common.isIBMJDK16()) {
                System.out.println("Not running as there is a problem with 1.6 jdk and restricted jars");
                return;
            }
            WSSecurity112Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity112Test.launchServer(Server12Restricted.class, (boolean)true));
            WSSecurity112Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity112Test.launchServer(StaxServer12Restricted.class, (boolean)true));
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        if (unrestrictedPoliciesInstalled) {
            return Arrays.asList({new TestParam("X", Server12.PORT, false)}, {new TestParam("X-NoTimestamp", Server12.PORT, false)}, {new TestParam("X-AES128", Server12.PORT, false)}, {new TestParam("X-AES256", Server12.PORT, false)}, {new TestParam("X-TripleDES", Server12.PORT, false)}, {new TestParam("XD", Server12.PORT, false)}, {new TestParam("XD-ES", Server12.PORT, false)}, {new TestParam("XD-SEES", Server12.PORT, false)}, {new TestParam("X", StaxServer12.PORT, false)}, {new TestParam("X-NoTimestamp", StaxServer12.PORT, false)}, {new TestParam("X-AES128", StaxServer12.PORT, false)}, {new TestParam("X-AES256", StaxServer12.PORT, false)}, {new TestParam("X-TripleDES", StaxServer12.PORT, false)}, {new TestParam("XD", StaxServer12.PORT, false)}, {new TestParam("XD-ES", StaxServer12.PORT, false)}, {new TestParam("XD-SEES", StaxServer12.PORT, false)});
        }
        return Arrays.asList({new TestParam("X", Server12Restricted.PORT, false)}, {new TestParam("X-NoTimestamp", Server12Restricted.PORT, false)}, {new TestParam("XD", Server12Restricted.PORT, false)}, {new TestParam("XD-ES", Server12Restricted.PORT, false)}, {new TestParam("XD-SEES", Server12Restricted.PORT, false)}, {new TestParam("X", StaxServer12Restricted.PORT, false)}, {new TestParam("X-NoTimestamp", StaxServer12Restricted.PORT, false)}, {new TestParam("XD", StaxServer12Restricted.PORT, false)}, {new TestParam("XD-ES", StaxServer12Restricted.PORT, false)}, {new TestParam("XD-SEES", StaxServer12Restricted.PORT, false)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecurity112Test.stopAllServers();
    }

    @Test
    public void testClientServer() throws IOException {
        if (!unrestrictedPoliciesInstalled && WSSecurity11Common.isIBMJDK16()) {
            System.out.println("Not running as there is a problem with 1.6 jdk and restricted jars");
            return;
        }
        this.runClientServer(this.test.prefix, this.test.port, unrestrictedPoliciesInstalled, this.test.streaming);
    }

    static class TestParam {
        final String prefix;
        final boolean streaming;
        final String port;

        public TestParam(String p, String port, boolean b) {
            this.prefix = p;
            this.port = port;
            this.streaming = b;
        }

        public String toString() {
            return this.prefix + ":" + this.port + ":" + (this.streaming ? "streaming" : "dom");
        }
    }
}

