/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec11;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import wssec.wssec11.IPingService;
import wssec.wssec11.PingService11;

public class WSSecurity11Common
extends AbstractBusClientServerTestBase {
    private static final String INPUT = "foo";

    public void runClientServer(String portPrefix, String portNumber, boolean unrestrictedPoliciesInstalled, boolean streaming) throws IOException {
        Bus bus = null;
        bus = unrestrictedPoliciesInstalled ? new SpringBusFactory().createBus("org/apache/cxf/systest/ws/wssec11/client.xml") : new SpringBusFactory().createBus("org/apache/cxf/systest/ws/wssec11/client_restricted.xml");
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdlLocation = null;
        PingService11 svc = null;
        wsdlLocation = WSSecurity11Common.getWsdlLocation(portPrefix, portNumber);
        svc = new PingService11(wsdlLocation);
        IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssec11", portPrefix + "_IPingService"), IPingService.class);
        if (streaming) {
            ((BindingProvider)port).getRequestContext().put("ws-security.enable.streaming", "true");
            ((BindingProvider)port).getResponseContext().put("ws-security.enable.streaming", "true");
        }
        String output = port.echo(INPUT);
        WSSecurity11Common.assertEquals((Object)INPUT, (Object)output);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    private static URL getWsdlLocation(String portPrefix, String portNumber) {
        try {
            return new URL("http://localhost:" + portNumber + "/" + portPrefix + "PingService?wsdl");
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    public static boolean isIBMJDK16() {
        String fullVersion = System.getProperty("java.fullversion");
        if (fullVersion == null) {
            return false;
        }
        if (fullVersion.indexOf("IBM") == -1) {
            return false;
        }
        String javaVersion = System.getProperty("java.version");
        double javaVersionNum = 0.0;
        javaVersionNum = javaVersion.length() > 3 ? new Double(javaVersion.substring(0, 3)).doubleValue() : new Double(javaVersion).doubleValue();
        return !(javaVersionNum < 1.6);
    }
}

