/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec11.server;

import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.apache.cxf.systest.ws.common.KeystorePasswordCallback;
import org.apache.cxf.systest.ws.wssec11.server.PingService;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;

abstract class AbstractServer
extends AbstractBusTestServerBase {
    String baseUrl;
    boolean streaming;

    protected AbstractServer(String baseUrl) throws Exception {
        this.baseUrl = baseUrl;
    }

    protected AbstractServer(String baseUrl, boolean streaming) throws Exception {
        this.baseUrl = baseUrl;
        this.streaming = streaming;
    }

    protected void run() {
        this.doPublish(this.baseUrl + "/APingService", new APingService());
        this.doPublish(this.baseUrl + "/A-NoTimestampPingService", new ANoTimestampPingService());
        this.doPublish(this.baseUrl + "/ADPingService", new ADPingService());
        this.doPublish(this.baseUrl + "/A-ESPingService", new AESPingService());
        this.doPublish(this.baseUrl + "/AD-ESPingService", new ADESPingService());
        this.doPublish(this.baseUrl + "/UXPingService", new UXPingService());
        this.doPublish(this.baseUrl + "/UX-NoTimestampPingService", new UXNoTimestampPingService());
        this.doPublish(this.baseUrl + "/UXDPingService", new UXDPingService());
        this.doPublish(this.baseUrl + "/UX-SEESPingService", new UXSEESPingService());
        this.doPublish(this.baseUrl + "/UXD-SEESPingService", new UXDSEESPingService());
        this.doPublish(this.baseUrl + "/XPingService", new XPingService());
        this.doPublish(this.baseUrl + "/X-NoTimestampPingService", new XNoTimestampPingService());
        this.doPublish(this.baseUrl + "/X-AES128PingService", new XAES128PingService());
        this.doPublish(this.baseUrl + "/X-AES256PingService", new XAES256PingService());
        this.doPublish(this.baseUrl + "/X-TripleDESPingService", new XTripleDESPingService());
        this.doPublish(this.baseUrl + "/XDPingService", new XDPingService());
        this.doPublish(this.baseUrl + "/XD-ESPingService", new XDESPingService());
        this.doPublish(this.baseUrl + "/XD-SEESPingService", new XDSEESPingService());
    }

    private void doPublish(String url, Object obj) {
        Endpoint ep = Endpoint.create((Object)obj);
        ep.getProperties().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ep.getProperties().put("ws-security.encryption.properties", "bob.properties");
        if (this.streaming) {
            ep.getProperties().put("ws-security.enable.streaming", "true");
        }
        ep.publish(url);
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="X-TripleDES_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class XTripleDESPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="X-AES256_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class XAES256PingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="X-AES128_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class XAES128PingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="XD-SEES_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class XDSEESPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="XD-ES_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class XDESPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="XD_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class XDPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="X-NoTimestamp_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class XNoTimestampPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="X_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class XPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="UXD-SEES_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class UXDSEESPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="UX-SEES_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class UXSEESPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="UXD_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class UXDPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="UX-NoTimestamp_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class UXNoTimestampPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="UX_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class UXPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="AD-ES_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class ADESPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="A-ES_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class AESPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="AD_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class ADPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="A-NoTimestamp_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class ANoTimestampPingService
    extends PingService {
    }

    @WebService(targetNamespace="http://WSSec/wssec11", serviceName="PingService11", portName="A_IPingService", endpointInterface="wssec.wssec11.IPingService", wsdlLocation="target/test-classes/wsdl_systest_wssec/wssec11/WsSecurity11.wsdl")
    public static class APingService
    extends PingService {
    }
}

