/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.cm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.cm.ConfigurationPermission;

final class ConfigurationPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -6917638867081695839L;
    private Map permissions = new HashMap();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("hasElement", Boolean.TYPE), new ObjectStreamField("permissions", HashMap.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof ConfigurationPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        ConfigurationPermission cp = (ConfigurationPermission)permission;
        String name = cp.getName();
        ConfigurationPermissionCollection configurationPermissionCollection = this;
        synchronized (configurationPermissionCollection) {
            Map pc = this.permissions;
            ConfigurationPermission existing = (ConfigurationPermission)pc.get(name);
            if (existing != null) {
                int oldMask = existing.action_mask;
                int newMask = cp.action_mask;
                if (oldMask != newMask) {
                    pc.put(name, new ConfigurationPermission(name, oldMask | newMask));
                }
            } else {
                pc.put(name, cp);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        Collection perms;
        if (!(permission instanceof ConfigurationPermission)) {
            return false;
        }
        ConfigurationPermission requested = (ConfigurationPermission)permission;
        int effective = 0;
        ConfigurationPermissionCollection configurationPermissionCollection = this;
        synchronized (configurationPermissionCollection) {
            int desired;
            ConfigurationPermission cp;
            Map pc = this.permissions;
            if (this.all_allowed && (cp = (ConfigurationPermission)pc.get("*")) != null && ((effective |= cp.action_mask) & (desired = requested.action_mask)) == desired) {
                return true;
            }
            perms = pc.values();
        }
        for (ConfigurationPermission perm : perms) {
            if (!perm.implies0(requested, effective)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        ArrayList all = new ArrayList(this.permissions.values());
        return Collections.enumeration(all);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("hasElement", false);
        pfields.put("permissions", this.permissions);
        pfields.put("all_allowed", this.all_allowed);
        out.writeFields();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        boolean hasElement = gfields.get("hasElement", false);
        if (hasElement) {
            this.permissions = new HashMap();
            this.permissions.put("*", new ConfigurationPermission("*", "configure"));
            this.all_allowed = true;
        } else {
            this.permissions = (HashMap)gfields.get("permissions", new HashMap());
            this.all_allowed = gfields.get("all_allowed", false);
        }
    }
}

