/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.webconsole.AttachmentProvider;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.ModeAwareConfigurationPrinter;
import org.osgi.framework.ServiceReference;

public class ConfigurationPrinterAdapter {
    private final Object printer;
    public String title;
    public String label;
    private final String[] modes;
    private final boolean escapeHtml;
    private Method modeAwarePrintMethod;
    private Method printMethod;
    private Method attachmentMethod;
    private boolean checkedAttachmentMethod = false;
    private static final List CUSTOM_MODES = new ArrayList();

    public static ConfigurationPrinterAdapter createAdapter(Object service, ServiceReference ref) {
        String title;
        Object cfgPrinter = null;
        Object modes = null;
        Method printMethod = null;
        if (service instanceof ConfigurationPrinter) {
            modes = ref.getProperty("felix.webconsole.configprinter.modes");
            if (modes == null) {
                modes = ref.getProperty("modes");
            }
            cfgPrinter = service;
            title = ((ConfigurationPrinter)service).getTitle();
        } else {
            Method method1Params;
            modes = ref.getProperty("felix.webconsole.configprinter.modes");
            title = (String)ref.getProperty("felix.webconsole.title");
            Method method2Params = ConfigurationPrinterAdapter.searchMethod(service, "printConfiguration", new Class[]{PrintWriter.class, String.class});
            if (method2Params != null) {
                cfgPrinter = service;
                printMethod = method2Params;
            }
            if (cfgPrinter == null && (method1Params = ConfigurationPrinterAdapter.searchMethod(service, "printConfiguration", new Class[]{PrintWriter.class})) != null) {
                cfgPrinter = service;
                printMethod = method1Params;
            }
        }
        if (cfgPrinter != null) {
            Object label = ref.getProperty("felix.webconsole.label");
            Object ehObj = ref.getProperty("felix.webconsole.configprinter.web.unescaped");
            boolean webUnescaped = ehObj instanceof Boolean ? (Boolean)ehObj : (ehObj instanceof String ? Boolean.valueOf((String)ehObj) : false);
            return new ConfigurationPrinterAdapter(cfgPrinter, printMethod, title, label instanceof String ? (String)label : null, modes, !webUnescaped);
        }
        return null;
    }

    private ConfigurationPrinterAdapter(Object printer, Method printMethod, String title, String label, Object modes, boolean escapeHtml) {
        this.printer = printer;
        this.title = title;
        this.label = label;
        this.escapeHtml = escapeHtml;
        if (printMethod != null) {
            if (printMethod.getParameterTypes().length > 1) {
                this.modeAwarePrintMethod = printMethod;
            } else {
                this.printMethod = printMethod;
            }
        }
        if (modes == null || !(modes instanceof String) && !(modes instanceof String[])) {
            this.modes = null;
        } else if (modes instanceof String) {
            this.modes = CUSTOM_MODES.contains(modes) ? new String[]{modes.toString()} : null;
        } else {
            String[] values = (String[])modes;
            boolean valid = values.length > 0;
            for (int i = 0; i < values.length; ++i) {
                if (CUSTOM_MODES.contains(values[i])) continue;
                valid = false;
                break;
            }
            this.modes = valid ? values : null;
        }
    }

    public boolean match(String mode) {
        if (this.modes == null) {
            return true;
        }
        for (int i = 0; i < this.modes.length; ++i) {
            if (!this.modes[i].equals(mode)) continue;
            return true;
        }
        return false;
    }

    public boolean escapeHtml() {
        return this.escapeHtml;
    }

    public final void printConfiguration(PrintWriter pw, String mode) {
        if (this.printer instanceof ModeAwareConfigurationPrinter) {
            ((ModeAwareConfigurationPrinter)this.printer).printConfiguration(pw, mode);
        } else if (this.printer instanceof ConfigurationPrinter) {
            ((ConfigurationPrinter)this.printer).printConfiguration(pw);
        } else if (this.modeAwarePrintMethod != null) {
            this.invoke(this.modeAwarePrintMethod, new Object[]{pw, mode});
        } else if (this.printMethod != null) {
            this.invoke(this.printMethod, new Object[]{pw});
        }
    }

    public URL[] getAttachments(String mode) {
        URL[] attachments = null;
        if (this.printer instanceof AttachmentProvider) {
            attachments = ((AttachmentProvider)this.printer).getAttachments(mode);
        } else {
            if (!this.checkedAttachmentMethod) {
                this.attachmentMethod = ConfigurationPrinterAdapter.searchMethod(this.printer, "getAttachments", new Class[]{String.class});
                this.checkedAttachmentMethod = true;
            }
            if (this.attachmentMethod != null) {
                attachments = (URL[])this.invoke(this.attachmentMethod, new Object[]{mode});
            }
        }
        return attachments;
    }

    public String toString() {
        return this.title + " (" + this.printer.getClass() + ")";
    }

    private static Method searchMethod(Object obj, String mName, Class[] params) {
        try {
            return obj.getClass().getDeclaredMethod(mName, params);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected Object invoke(Method m, Object[] args) {
        try {
            return m.invoke(this.printer, args);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        CUSTOM_MODES.add("txt");
        CUSTOM_MODES.add("web");
        CUSTOM_MODES.add("zip");
    }
}

