/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.felix.webconsole.WebConsoleSecurityProvider2;
import org.apache.felix.webconsole.internal.servlet.Base64;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

final class OsgiManagerHttpContext
implements HttpContext {
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private final HttpContext base;
    private final ServiceTracker tracker;
    private final String username;
    private final String password;
    private final String realm;

    OsgiManagerHttpContext(HttpService httpService, ServiceTracker tracker, String username, String password, String realm) {
        this.tracker = tracker;
        this.username = username;
        this.password = password;
        this.realm = realm;
        this.base = httpService.createDefaultHttpContext();
    }

    public String getMimeType(String name) {
        return this.base.getMimeType(name);
    }

    public URL getResource(String name) {
        URL url = this.base.getResource(name);
        if (url == null && name.endsWith("/")) {
            return this.base.getResource(name.substring(0, name.length() - 1));
        }
        return url;
    }

    public boolean handleSecurity(HttpServletRequest originalRequest, HttpServletResponse response) {
        int blank;
        Object provider = this.tracker.getService();
        HttpServletRequest request = originalRequest;
        if (OsgiManager.isLoginRequired(originalRequest)) {
            request = this.forceLogin(originalRequest);
        }
        if (provider instanceof WebConsoleSecurityProvider2) {
            return ((WebConsoleSecurityProvider2)provider).authenticate(request, response);
        }
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
                try {
                    String srcString = OsgiManagerHttpContext.base64Decode(authInfo);
                    int i = srcString.indexOf(58);
                    String username = srcString.substring(0, i);
                    String password = srcString.substring(i + 1);
                    if (this.authenticate(provider, username, password)) {
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        request.setAttribute("org.apache.felix.webconsole.user", (Object)username);
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return false;
    }

    public boolean authorize(HttpServletRequest request, String role) {
        Object user = request.getAttribute("org.apache.felix.webconsole.user");
        if (user != null) {
            WebConsoleSecurityProvider provider = (WebConsoleSecurityProvider)this.tracker.getService();
            if (provider != null) {
                return provider.authorize(user, role);
            }
            return true;
        }
        return false;
    }

    private static String base64Decode(String srcString) {
        byte[] transformed = Base64.decodeBase64(srcString);
        try {
            return new String(transformed, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(transformed);
        }
    }

    private boolean authenticate(Object provider, String username, String password) {
        if (provider != null) {
            return ((WebConsoleSecurityProvider)provider).authenticate(username, password) != null;
        }
        return this.username.equals(username) && this.password.equals(password);
    }

    private HttpServletRequest forceLogin(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){

            public String getHeader(String name) {
                if (OsgiManagerHttpContext.HEADER_AUTHORIZATION.equals(name)) {
                    return null;
                }
                return super.getHeader(name);
            }
        };
    }
}

