/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.fusesource.jansi.Ansi;

@Command(scope="shell", name="grep", description="Prints lines matching the given pattern")
public class GrepAction
extends OsgiCommandSupport {
    @Argument(index=0, name="pattern", description="Regular expression", required=true, multiValued=false)
    private String regex;
    @Option(name="-n", aliases={"--line-number"}, description="Prefixes each line of output with the line number within its input file.", required=false, multiValued=false)
    private boolean lineNumber;
    @Option(name="-v", aliases={"--invert-match"}, description="Inverts the sense of matching, to select non-matching lines.", required=false, multiValued=false)
    private boolean invertMatch;
    @Option(name="-w", aliases={"--word-regexp"}, description="Selects only those lines containing matches that form whole words.  The test is that the matching substring must either be at  the beginning of the line, or preceded by a non-word constituent character.  Similarly, it must be either at the end of the line or followed by a non-word constituent character.  Word-constituent characters are letters, digits, and the underscore.", required=false, multiValued=false)
    private boolean wordRegexp;
    @Option(name="-x", aliases={"--line-regexp"}, description="Selects only those matches that exactly match the whole line.", required=false, multiValued=false)
    private boolean lineRegexp;
    @Option(name="-i", aliases={"--ignore-case"}, description="Ignores case distinctions in both the PATTERN and the input files.", required=false, multiValued=false)
    private boolean ignoreCase;
    @Option(name="-c", aliases={"--count"}, description="only print a count of matching lines per FILE", required=false, multiValued=false)
    private boolean count;
    @Option(name="--color", aliases={"--colour"}, description="use markers to distinguish the matching string. WHEN may be `always', `never' or `auto'", required=false, multiValued=false)
    private ColorOption color = ColorOption.auto;
    @Option(name="-B", aliases={"--before-context"}, description="Print NUM lines of leading context before matching lines.  Places a line containing -- between contiguous groups of matches.", required=false, multiValued=false)
    private int before = -1;
    @Option(name="-A", aliases={"--after-context"}, description="Print NUM lines of trailing context after matching lines.  Places a line containing -- between contiguous groups of matches.", required=false, multiValued=false)
    private int after = -1;
    @Option(name="-C", aliases={"--context"}, description="Print NUM lines of output context.  Places a line containing -- between contiguous groups of matches.", required=false, multiValued=false)
    private int context = 0;

    protected Object doExecute() throws Exception {
        Pattern p2;
        Pattern p;
        if (this.after < 0) {
            this.after = this.context;
        }
        if (this.before < 0) {
            this.before = this.context;
        }
        ArrayList<String> lines = new ArrayList<String>();
        String regexp = this.regex;
        if (this.wordRegexp) {
            regexp = "\\b" + regexp + "\\b";
        }
        regexp = this.lineRegexp ? "^" + regexp + "$" : ".*" + regexp + ".*";
        if (this.ignoreCase) {
            p = Pattern.compile(regexp, 2);
            p2 = Pattern.compile(this.regex, 2);
        } else {
            p = Pattern.compile(regexp);
            p2 = Pattern.compile(this.regex);
        }
        try {
            String line;
            boolean firstPrint = true;
            int nb = 0;
            int lineno = 1;
            int lineMatch = 0;
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            while ((line = r.readLine()) != null && (line.length() != 1 || line.charAt(0) != '\n')) {
                if (p.matcher(line).matches() ^ this.invertMatch) {
                    Matcher matcher2 = p2.matcher(line);
                    StringBuffer sb = new StringBuffer();
                    while (matcher2.find()) {
                        if (!this.invertMatch && this.color != ColorOption.never) {
                            matcher2.appendReplacement(sb, Ansi.ansi().bg(Ansi.Color.YELLOW).fg(Ansi.Color.BLACK).a(matcher2.group()).reset().toString());
                        } else {
                            matcher2.appendReplacement(sb, matcher2.group());
                        }
                        ++nb;
                    }
                    matcher2.appendTail(sb);
                    if (!this.count && this.lineNumber) {
                        lines.add(String.format("%6d  ", lineno) + sb.toString());
                    } else {
                        lines.add(sb.toString());
                    }
                    lineMatch = lines.size();
                } else {
                    if (lineMatch != 0 & lineMatch + this.after + this.before <= lines.size()) {
                        if (!this.count) {
                            if (!firstPrint && this.before + this.after > 0) {
                                System.out.println("--");
                            } else {
                                firstPrint = false;
                            }
                            for (int i = 0; i < lineMatch + this.after; ++i) {
                                System.out.println((String)lines.get(i));
                            }
                        }
                        while (lines.size() > this.before) {
                            lines.remove(0);
                        }
                        lineMatch = 0;
                    }
                    lines.add(line);
                    while (lineMatch == 0 && lines.size() > this.before) {
                        lines.remove(0);
                    }
                }
                ++lineno;
            }
            if (!this.count && lineMatch > 0) {
                if (!firstPrint && this.before + this.after > 0) {
                    System.out.println("--");
                } else {
                    firstPrint = false;
                }
                for (int i = 0; i < lineMatch + this.after && i < lines.size(); ++i) {
                    System.out.println((String)lines.get(i));
                }
            }
            if (this.count) {
                System.out.println(nb);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorOption {
        never,
        always,
        auto;

    }
}

