/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.dev.AbstractBundleCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="dev", name="dynamic-import", description="Enable/disable dynamic-import for a given bundle")
public class DynamicImport
extends AbstractBundleCommand {
    private static final Log LOG = LogFactory.getLog(DynamicImport.class);
    protected static final String ORIGINAL_WIRES = "Original-Wires";

    @Override
    protected void doExecute(Bundle bundle) throws Exception {
        if (bundle.getHeaders().get(ORIGINAL_WIRES) == null) {
            this.enableDynamicImports(bundle);
        } else {
            this.disableDynamicImports(bundle);
        }
    }

    private void enableDynamicImports(Bundle bundle) throws IOException, BundleException {
        System.out.printf("Enabling dynamic imports on bundle %s%n", bundle);
        String location = String.format("wrap:%s$Bundle-UpdateLocation=%s&DynamicImport-Package=*&%s=%s&overwrite=merge", bundle.getLocation(), bundle.getLocation(), ORIGINAL_WIRES, this.explode(this.getWiredBundles(bundle).keySet()));
        LOG.debug((Object)String.format("Updating %s with URL %s", bundle, location));
        URL url = new URL(location);
        bundle.update(url.openStream());
        this.getPackageAdmin().refreshPackages(new Bundle[]{bundle});
    }

    private void disableDynamicImports(Bundle bundle) throws BundleException {
        System.out.printf("Disabling dynamic imports on bundle %s%n", bundle);
        Set<String> current = this.getWiredBundles(bundle).keySet();
        for (String original : bundle.getHeaders().get(ORIGINAL_WIRES).toString().split(",")) {
            current.remove(original);
        }
        if (current.isEmpty()) {
            System.out.println("(no additional packages have been wired since dynamic import was enabled)");
        } else {
            System.out.printf("%nAdditional packages wired since dynamic import was enabled:%n", new Object[0]);
            for (String pkg : current) {
                System.out.printf("- %s%n", pkg);
            }
        }
        bundle.update();
    }

    private String explode(Set<String> set) {
        StringBuffer result = new StringBuffer();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }
}

