/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.BrandingPlugin;

public class DefaultBrandingPlugin
implements BrandingPlugin {
    private static final String BRANDING_PROPERTIES = "/META-INF/webconsole.properties";
    private static DefaultBrandingPlugin instance;
    private final String brandName;
    private final String productName;
    private final String productURL;
    private final String productImage;
    private final String vendorName;
    private final String vendorURL;
    private final String vendorImage;
    private final String favIcon;
    private final String mainStyleSheet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultBrandingPlugin() {
        Properties props = new Properties();
        InputStream ins = this.getClass().getResourceAsStream(BRANDING_PROPERTIES);
        if (ins != null) {
            try {
                props.load(ins);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)ins);
            }
        }
        this.brandName = props.getProperty("webconsole.brand.name", "Apache Felix Web Console");
        this.productName = props.getProperty("webconsole.product.name", "Apache Felix");
        this.productURL = props.getProperty("webconsole.product.url", "http://felix.apache.org");
        this.productImage = props.getProperty("webconsole.product.image", "/res/imgs/logo.png");
        this.vendorName = props.getProperty("webconsole.vendor.name", "The Apache Software Foundation");
        this.vendorURL = props.getProperty("webconsole.vendor.url", "http://www.apache.org");
        this.vendorImage = props.getProperty("webconsole.vendor.image", "/res/imgs/logo.png");
        this.favIcon = props.getProperty("webconsole.favicon", "/res/imgs/favicon.ico");
        this.mainStyleSheet = props.getProperty("webconsole.stylesheet", "/res/ui/webconsole.css");
    }

    public static DefaultBrandingPlugin getInstance() {
        if (instance == null) {
            instance = new DefaultBrandingPlugin();
        }
        return instance;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductURL() {
        return this.productURL;
    }

    public String getProductImage() {
        return this.productImage;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getVendorURL() {
        return this.vendorURL;
    }

    public String getVendorImage() {
        return this.vendorImage;
    }

    public String getFavIcon() {
        return this.favIcon;
    }

    public String getMainStyleSheet() {
        return this.mainStyleSheet;
    }
}

