/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import jline.AnsiWindowsTerminal;
import jline.NoInterruptUnixTerminal;
import jline.Terminal;
import jline.UnsupportedTerminal;

public class TerminalFactory {
    private Terminal term;

    public synchronized Terminal getTerminal() throws Exception {
        if (this.term == null) {
            this.init();
        }
        return this.term;
    }

    public void init() throws Exception {
        if ("jline.UnsupportedTerminal".equals(System.getProperty("jline.terminal"))) {
            this.term = new UnsupportedTerminal();
            return;
        }
        boolean windows = System.getProperty("os.name").toLowerCase().contains("windows");
        try {
            if (windows) {
                AnsiWindowsTerminal t = new AnsiWindowsTerminal();
                t.setDirectConsole(true);
                t.initializeTerminal();
                this.term = t;
            } else {
                NoInterruptUnixTerminal t = new NoInterruptUnixTerminal();
                t.initializeTerminal();
                this.term = t;
            }
        }
        catch (Throwable e) {
            System.out.println("Using an unsupported terminal: " + e.toString());
            this.term = new UnsupportedTerminal();
        }
    }

    public synchronized void destroy() throws Exception {
        if (this.term != null) {
            this.term.restoreTerminal();
            this.term = null;
        }
    }
}

