/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.proxy;

import java.lang.reflect.Method;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.proxy.Collaborator;
import org.apache.aries.blueprint.proxy.WrapperedObject;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CgLibInterceptorWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CgLibInterceptorWrapper.class);

    public static Object createProxyObject(ClassLoader cl, ComponentMetadata cm, List<Interceptor> interceptors, Object delegate, Class<?> ... classesToProxy) {
        LOGGER.debug("createProxyObject " + cm.getId() + " " + delegate);
        final Collaborator c = new Collaborator(cm, interceptors, delegate);
        Enhancer e = new Enhancer();
        e.setClassLoader((ClassLoader)new BridgingClassLoader(cl));
        e.setInterceptDuringConstruction(false);
        int origIfLen = 0;
        if (classesToProxy != null) {
            origIfLen = classesToProxy.length;
        }
        Class[] ifs = new Class[origIfLen + 1];
        ifs[0] = WrapperedObject.class;
        if (classesToProxy != null && classesToProxy.length > 0) {
            for (int i = 1; i < classesToProxy.length + 1; ++i) {
                ifs[i] = classesToProxy[i - 1];
            }
        }
        e.setInterfaces(ifs);
        e.setSuperclass(delegate.getClass());
        e.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object arg0, Method arg1, Object[] arg2, MethodProxy arg3) throws Throwable {
                return c.invoke(arg0, arg1, arg2);
            }
        });
        Object wrappered = null;
        try {
            wrappered = e.create();
        }
        catch (IllegalArgumentException iae) {
            throw new ComponentDefinitionException("Unable to proxy bean for interceptors: " + iae);
        }
        return wrappered;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BridgingClassLoader
    extends ClassLoader {
        private ClassLoader cgLibClassLoader;
        private ClassLoader blueprintClassLoader;
        private ClassLoader delegateClassLoader;

        public BridgingClassLoader(ClassLoader delegate) {
            this.delegateClassLoader = delegate;
            this.cgLibClassLoader = Enhancer.class.getClassLoader();
            this.blueprintClassLoader = this.getClass().getClassLoader();
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            if (className.equals("org.apache.aries.blueprint.proxy.WrapperedObject")) {
                return this.blueprintClassLoader.loadClass(className);
            }
            if (className.startsWith("net.sf.cglib")) {
                return this.cgLibClassLoader.loadClass(className);
            }
            return this.delegateClassLoader.loadClass(className);
        }
    }
}

