/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.framework.BundleState;
import org.apache.aries.jmx.framework.RegistrableStandardEmitterMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundleStateMBeanHandler
implements MBeanHandler {
    private Logger logger;
    private String name;
    private StandardMBean mbean;
    private BundleState bundleStateMBean;
    private BundleContext bundleContext;
    private ServiceReference packageAdminRef;
    private ServiceReference startLevelRef;

    public BundleStateMBeanHandler(BundleContext bundleContext, Logger logger) {
        this.bundleContext = bundleContext;
        this.logger = logger;
        this.name = "osgi.core:type=bundleState,version=1.5";
    }

    public void open() {
        this.packageAdminRef = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(this.packageAdminRef);
        this.startLevelRef = this.bundleContext.getServiceReference(StartLevel.class.getName());
        StartLevel startLevel = (StartLevel)this.bundleContext.getService(this.startLevelRef);
        this.bundleStateMBean = new BundleState(this.bundleContext, packageAdmin, startLevel, this.logger);
        try {
            this.mbean = new RegistrableStandardEmitterMBean(this.bundleStateMBean, BundleStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.logger.log(1, "Failed to instantiate MBean for " + BundleStateMBean.class.getName(), e);
        }
    }

    public StandardMBean getMbean() {
        return this.mbean;
    }

    public String getName() {
        return this.name;
    }

    public void close() {
        if (this.packageAdminRef != null) {
            try {
                this.bundleContext.ungetService(this.packageAdminRef);
            }
            catch (RuntimeException e) {
                this.logger.log(2, "Exception occured during cleanup", e);
            }
            this.packageAdminRef = null;
        }
        if (this.startLevelRef != null) {
            try {
                this.bundleContext.ungetService(this.startLevelRef);
            }
            catch (RuntimeException e) {
                this.logger.log(2, "Exception occured during cleanup", e);
            }
            this.startLevelRef = null;
        }
        if (this.bundleStateMBean != null) {
            this.bundleStateMBean.shutDownDispatcher();
        }
    }
}

