/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jline.Terminal;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.impl.SimpleLogger;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String host = "localhost";
        int port = 8101;
        String user = "karaf";
        String password = "karaf";
        StringBuilder sb = new StringBuilder();
        int level = 1;
        int retryAttempts = 0;
        int retryDelay = 2;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-a")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    host = args[++i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    user = args[++i];
                    continue;
                }
                if (args[i].equals("-p")) {
                    password = args[++i];
                    continue;
                }
                if (args[i].equals("-v")) {
                    ++level;
                    continue;
                }
                if (args[i].equals("-r")) {
                    retryAttempts = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-d")) {
                    retryDelay = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("--help")) {
                    System.out.println("Apache Karaf client");
                    System.out.println("  -a [port]     specify the port to connect to");
                    System.out.println("  -h [host]     specify the host to connect to");
                    System.out.println("  -u [user]     specify the user name");
                    System.out.println("  -p [password] specify the password");
                    System.out.println("  --help        shows this help message");
                    System.out.println("  -v            raise verbosity");
                    System.out.println("  -r [attempts] retry connection establishment (up to attempts times)");
                    System.out.println("  -d [delay]    intra-retry delay (defaults to 2 seconds)");
                    System.out.println("  [commands]    commands to run");
                    System.out.println("If no commands are specified, the client will be put in an interactive mode");
                    System.exit(0);
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.err.println("Run with --help for usage");
                System.exit(1);
                continue;
            }
            sb.append(args[i]);
            sb.append(' ');
        }
        SimpleLogger.setLevel(level);
        SshClient client = null;
        Terminal terminal = null;
        try {
            ClientChannel channel;
            client = SshClient.setUpDefaultClient();
            client.start();
            int retries = 0;
            ClientSession session = null;
            do {
                ConnectFuture future = client.connect(host, port);
                future.await();
                try {
                    session = future.getSession();
                }
                catch (RuntimeSshException ex) {
                    if (retries++ < retryAttempts) {
                        Thread.sleep(retryDelay * 1000);
                        System.out.println("retrying (attempt " + retries + ") ...");
                        continue;
                    }
                    throw ex;
                }
            } while (session == null);
            if (!((AuthFuture)session.authPassword(user, password).await()).isSuccess()) {
                throw new Exception("Authentication failure");
            }
            if (sb.length() > 0) {
                channel = session.createChannel("exec", sb.append("\n").toString());
                channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
            } else {
                terminal = new TerminalFactory().getTerminal();
                channel = session.createChannel("shell");
                channel.setIn((InputStream)new NoCloseInputStream(System.in));
                ((ChannelShell)channel).setupSensibleDefaultPty();
            }
            channel.setOut(AnsiConsole.wrapOutputStream((OutputStream)System.out));
            channel.setErr(AnsiConsole.wrapOutputStream((OutputStream)System.err));
            channel.open();
            channel.waitFor(2, 0L);
        }
        catch (Throwable t) {
            if (level > 1) {
                t.printStackTrace();
            } else {
                System.err.println(t.getMessage());
            }
            System.exit(1);
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable t) {}
            try {
                if (terminal != null) {
                    terminal.restoreTerminal();
                }
            }
            catch (Throwable t) {}
        }
        System.exit(0);
    }
}

