/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.service.AbstractIoService;

public class IoServiceStatistics {
    private AbstractIoService service;
    private double readBytesThroughput;
    private double writtenBytesThroughput;
    private double readMessagesThroughput;
    private double writtenMessagesThroughput;
    private double largestReadBytesThroughput;
    private double largestWrittenBytesThroughput;
    private double largestReadMessagesThroughput;
    private double largestWrittenMessagesThroughput;
    private final AtomicLong readBytes = new AtomicLong();
    private final AtomicLong writtenBytes = new AtomicLong();
    private final AtomicLong readMessages = new AtomicLong();
    private final AtomicLong writtenMessages = new AtomicLong();
    private long lastReadTime;
    private long lastWriteTime;
    private long lastReadBytes;
    private long lastWrittenBytes;
    private long lastReadMessages;
    private long lastWrittenMessages;
    private long lastThroughputCalculationTime;
    private final AtomicInteger scheduledWriteBytes = new AtomicInteger();
    private final AtomicInteger scheduledWriteMessages = new AtomicInteger();
    private int throughputCalculationInterval = 3;
    private final Object throughputCalculationLock = new Object();

    public IoServiceStatistics(AbstractIoService service) {
        this.service = service;
    }

    public final int getLargestManagedSessionCount() {
        return this.service.getListeners().getLargestManagedSessionCount();
    }

    public final long getCumulativeManagedSessionCount() {
        return this.service.getListeners().getCumulativeManagedSessionCount();
    }

    public final long getLastIoTime() {
        return Math.max(this.lastReadTime, this.lastWriteTime);
    }

    public final long getLastReadTime() {
        return this.lastReadTime;
    }

    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public final long getReadBytes() {
        return this.readBytes.get();
    }

    public final long getWrittenBytes() {
        return this.writtenBytes.get();
    }

    public final long getReadMessages() {
        return this.readMessages.get();
    }

    public final long getWrittenMessages() {
        return this.writtenMessages.get();
    }

    public final double getReadBytesThroughput() {
        this.resetThroughput();
        return this.readBytesThroughput;
    }

    public final double getWrittenBytesThroughput() {
        this.resetThroughput();
        return this.writtenBytesThroughput;
    }

    public final double getReadMessagesThroughput() {
        this.resetThroughput();
        return this.readMessagesThroughput;
    }

    public final double getWrittenMessagesThroughput() {
        this.resetThroughput();
        return this.writtenMessagesThroughput;
    }

    public final double getLargestReadBytesThroughput() {
        return this.largestReadBytesThroughput;
    }

    public final double getLargestWrittenBytesThroughput() {
        return this.largestWrittenBytesThroughput;
    }

    public final double getLargestReadMessagesThroughput() {
        return this.largestReadMessagesThroughput;
    }

    public final double getLargestWrittenMessagesThroughput() {
        return this.largestWrittenMessagesThroughput;
    }

    public final int getThroughputCalculationInterval() {
        return this.throughputCalculationInterval;
    }

    public final long getThroughputCalculationIntervalInMillis() {
        return (long)this.throughputCalculationInterval * 1000L;
    }

    public final void setThroughputCalculationInterval(int throughputCalculationInterval) {
        if (throughputCalculationInterval < 0) {
            throw new IllegalArgumentException("throughputCalculationInterval: " + throughputCalculationInterval);
        }
        this.throughputCalculationInterval = throughputCalculationInterval;
    }

    protected final void setLastReadTime(long lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    protected final void setLastWriteTime(long lastWriteTime) {
        this.lastWriteTime = lastWriteTime;
    }

    private void resetThroughput() {
        if (this.service.getManagedSessionCount() == 0) {
            this.readBytesThroughput = 0.0;
            this.writtenBytesThroughput = 0.0;
            this.readMessagesThroughput = 0.0;
            this.writtenMessagesThroughput = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThroughput(long currentTime) {
        Object object = this.throughputCalculationLock;
        synchronized (object) {
            int interval = (int)(currentTime - this.lastThroughputCalculationTime);
            long minInterval = this.getThroughputCalculationIntervalInMillis();
            if (minInterval == 0L || (long)interval < minInterval) {
                return;
            }
            long readBytes = this.readBytes.get();
            long writtenBytes = this.writtenBytes.get();
            long readMessages = this.readMessages.get();
            long writtenMessages = this.writtenMessages.get();
            this.readBytesThroughput = (double)(readBytes - this.lastReadBytes) * 1000.0 / (double)interval;
            this.writtenBytesThroughput = (double)(writtenBytes - this.lastWrittenBytes) * 1000.0 / (double)interval;
            this.readMessagesThroughput = (double)(readMessages - this.lastReadMessages) * 1000.0 / (double)interval;
            this.writtenMessagesThroughput = (double)(writtenMessages - this.lastWrittenMessages) * 1000.0 / (double)interval;
            if (this.readBytesThroughput > this.largestReadBytesThroughput) {
                this.largestReadBytesThroughput = this.readBytesThroughput;
            }
            if (this.writtenBytesThroughput > this.largestWrittenBytesThroughput) {
                this.largestWrittenBytesThroughput = this.writtenBytesThroughput;
            }
            if (this.readMessagesThroughput > this.largestReadMessagesThroughput) {
                this.largestReadMessagesThroughput = this.readMessagesThroughput;
            }
            if (this.writtenMessagesThroughput > this.largestWrittenMessagesThroughput) {
                this.largestWrittenMessagesThroughput = this.writtenMessagesThroughput;
            }
            this.lastReadBytes = readBytes;
            this.lastWrittenBytes = writtenBytes;
            this.lastReadMessages = readMessages;
            this.lastWrittenMessages = writtenMessages;
            this.lastThroughputCalculationTime = currentTime;
        }
    }

    public final void increaseReadBytes(long increment, long currentTime) {
        this.readBytes.addAndGet(increment);
        this.lastReadTime = currentTime;
    }

    public final void increaseReadMessages(long currentTime) {
        this.readMessages.incrementAndGet();
        this.lastReadTime = currentTime;
    }

    public final void increaseWrittenBytes(int increment, long currentTime) {
        this.writtenBytes.addAndGet(increment);
        this.lastWriteTime = currentTime;
    }

    public final void increaseWrittenMessages(long currentTime) {
        this.writtenMessages.incrementAndGet();
        this.lastWriteTime = currentTime;
    }

    public final int getScheduledWriteBytes() {
        return this.scheduledWriteBytes.get();
    }

    public final void increaseScheduledWriteBytes(int increment) {
        this.scheduledWriteBytes.addAndGet(increment);
    }

    public final int getScheduledWriteMessages() {
        return this.scheduledWriteMessages.get();
    }

    public final void increaseScheduledWriteMessages() {
        this.scheduledWriteMessages.incrementAndGet();
    }

    public final void decreaseScheduledWriteMessages() {
        this.scheduledWriteMessages.decrementAndGet();
    }

    protected void setLastThroughputCalculationTime(long lastThroughputCalculationTime) {
        this.lastThroughputCalculationTime = lastThroughputCalculationTime;
    }
}

