/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.OCD;
import org.apache.felix.metatype.internal.LocalizedObjectClassDefinition;
import org.apache.felix.metatype.internal.l10n.BundleResources;
import org.apache.felix.metatype.internal.l10n.Resources;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class DefaultMetaTypeProvider
implements MetaTypeProvider {
    private final Bundle bundle;
    private final String localePrefix;
    private Map objectClassDefinitions;
    private Map designates;
    private Map locales;

    public DefaultMetaTypeProvider(Bundle bundle, MetaData metadata) {
        HashMap copy;
        this.bundle = bundle;
        if (metadata.getObjectClassDefinitions() == null) {
            this.objectClassDefinitions = Collections.EMPTY_MAP;
        } else {
            copy = new HashMap(metadata.getObjectClassDefinitions());
            this.objectClassDefinitions = Collections.unmodifiableMap(copy);
        }
        if (metadata.getDesignates() == null) {
            this.designates = Collections.EMPTY_MAP;
        } else {
            copy = new HashMap(metadata.getDesignates());
            this.designates = Collections.unmodifiableMap(copy);
        }
        String metaDataLocalePrefix = metadata.getLocalePrefix();
        if (metaDataLocalePrefix == null && (metaDataLocalePrefix = (String)bundle.getHeaders().get("Bundle-Localization")) == null) {
            metaDataLocalePrefix = "OSGI-INF/l10n/bundle";
        }
        this.localePrefix = metaDataLocalePrefix;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String[] getLocales() {
        if (this.locales == null) {
            String pattern;
            String path;
            int lastSlash = this.localePrefix.lastIndexOf(47);
            if (lastSlash < 0) {
                path = "/";
                pattern = this.localePrefix;
            } else {
                path = this.localePrefix.substring(0, lastSlash);
                pattern = this.localePrefix.substring(lastSlash + 1);
            }
            Enumeration entries = this.getBundle().findEntries(path, pattern + "*.properties", false);
            this.locales = new TreeMap();
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                String name = url.getPath();
                if ((name = name.substring(name.lastIndexOf(47) + 1 + pattern.length(), name.length() - ".properties".length())).startsWith("_")) {
                    name = name.substring(1);
                }
                this.locales.put(name, url);
            }
        }
        if (this.locales.isEmpty()) {
            return null;
        }
        return this.locales.keySet().toArray(new String[this.locales.size()]);
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        Designate designate = this.getDesignate(id);
        if (designate == null || designate.getObject() == null) {
            return null;
        }
        String ocdRef = designate.getObject().getOcdRef();
        OCD ocd = (OCD)this.objectClassDefinitions.get(ocdRef);
        if (ocd == null) {
            return null;
        }
        Resources resources = BundleResources.getResources(this.bundle, this.localePrefix, locale);
        return new LocalizedObjectClassDefinition(this.bundle, ocd, resources);
    }

    public Designate getDesignate(String pid) {
        return (Designate)this.designates.get(pid);
    }

    protected Map getObjectClassDefinitions() {
        return this.objectClassDefinitions;
    }

    protected Map getDesignates() {
        return this.designates;
    }
}

