/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.metatype.DefaultMetaTypeProvider;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.DesignateObject;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.OCD;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetaTypeInformationImpl
implements MetaTypeInformation {
    public static final String SERVICE_FACTORYPID = "service.factoryPid";
    private final Bundle bundle;
    private Set pids;
    private Set factoryPids;
    private Set locales;
    private Map metaTypeProviders;

    protected MetaTypeInformationImpl(Bundle bundle) {
        this.bundle = bundle;
        this.pids = new TreeSet();
        this.factoryPids = new TreeSet();
        this.metaTypeProviders = new HashMap();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String[] getFactoryPids() {
        return this.factoryPids.toArray(new String[this.factoryPids.size()]);
    }

    public String[] getPids() {
        return this.pids.toArray(new String[this.pids.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocales() {
        if (this.locales == null) {
            MetaTypeInformationImpl metaTypeInformationImpl = this;
            synchronized (metaTypeInformationImpl) {
                TreeSet newLocales = new TreeSet();
                Iterator mi = this.metaTypeProviders.values().iterator();
                while (mi.hasNext()) {
                    MetaTypeProvider mtp = (MetaTypeProvider)mi.next();
                    this.addValues(newLocales, mtp.getLocales());
                }
                this.locales = newLocales;
            }
        }
        return this.locales.toArray(new String[this.locales.size()]);
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        MetaTypeProvider mtp = (MetaTypeProvider)this.metaTypeProviders.get(id);
        return mtp != null ? mtp.getObjectClassDefinition(id, locale) : null;
    }

    Designate getDesignate(String pid) {
        Object mto = this.metaTypeProviders.get(pid);
        if (mto instanceof DefaultMetaTypeProvider) {
            return ((DefaultMetaTypeProvider)mto).getDesignate(pid);
        }
        return null;
    }

    protected void addMetaData(MetaData md) {
        if (md.getDesignates() != null) {
            DefaultMetaTypeProvider dmtp = new DefaultMetaTypeProvider(this.bundle, md);
            Iterator designates = md.getDesignates().values().iterator();
            while (designates.hasNext()) {
                OCD ocd;
                Designate designate = (Designate)designates.next();
                DesignateObject object = designate.getObject();
                String ocdRef = object == null ? null : object.getOcdRef();
                if (ocdRef == null || (ocd = (OCD)md.getObjectClassDefinitions().get(ocdRef)) == null) continue;
                if (designate.getFactoryPid() != null) {
                    this.factoryPids.add(designate.getFactoryPid());
                } else {
                    this.pids.add(designate.getPid());
                }
                this.addMetaTypeProvider(designate.getPid(), dmtp);
            }
        }
    }

    protected void addPids(String[] pids) {
        this.addValues(this.pids, pids);
    }

    protected void removePid(String pid) {
        this.pids.remove(pid);
    }

    protected void addFactoryPids(String[] factoryPids) {
        this.addValues(this.factoryPids, factoryPids);
    }

    protected void removeFactoryPid(String factoryPid) {
        this.factoryPids.remove(factoryPid);
    }

    protected void addMetaTypeProvider(String key, MetaTypeProvider mtp) {
        if (key != null && mtp != null) {
            this.metaTypeProviders.put(key, mtp);
            this.locales = null;
        }
    }

    protected MetaTypeProvider removeMetaTypeProvider(String key) {
        if (key != null) {
            this.locales = null;
            return (MetaTypeProvider)this.metaTypeProviders.remove(key);
        }
        return null;
    }

    private void addValues(Collection dest, Object[] values) {
        if (values != null && values.length > 0) {
            dest.addAll(Arrays.asList(values));
        }
    }
}

