/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.RolePrincipal;
import org.apache.karaf.jaas.modules.UserPrincipal;
import org.apache.karaf.jaas.modules.properties.PropertiesLoginModule;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCLoginModule
extends AbstractKarafLoginModule {
    private static final Log LOG = LogFactory.getLog(PropertiesLoginModule.class);
    private static final String DATASOURCE = "datasource";
    private static final String PASSWORD_QUERY = "query.password";
    private static final String ROLE_QUERY = "query.role";
    private static final String JNDI = "jndi:";
    private static final String OSGI = "osgi:";
    private String datasourceURL;
    protected String passwordQuery = "SELECT PASSWORD FROM USERS WHERE USERNAME=?";
    protected String roleQuery = "SELECT ROLE FROM ROLES WHERE USERNAME=?";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
        this.datasourceURL = (String)options.get(DATASOURCE);
        this.passwordQuery = (String)options.get(PASSWORD_QUERY);
        this.roleQuery = (String)options.get(ROLE_QUERY);
        if (this.datasourceURL == null || this.datasourceURL.trim().length() == 0) {
            LOG.error((Object)"No datasource was specified ");
        } else if (!this.datasourceURL.startsWith(JNDI) && !this.datasourceURL.startsWith(OSGI)) {
            LOG.error((Object)"Invalid datasource lookup protocol");
        }
    }

    public Object createDatasource(String url) throws Exception {
        if (url == null) {
            throw new Exception("Illegal datasource url format. Datasource URL cannot be null.");
        }
        if (url.trim().length() == 0) {
            throw new Exception("Illegal datasource url format. Datasource URL cannot be empty.");
        }
        if (url.startsWith(JNDI)) {
            String jndiName = url.substring(JNDI.length());
            InitialContext ic = new InitialContext();
            Object ds = ic.lookup(jndiName);
            return ds;
        }
        if (url.startsWith(OSGI)) {
            ServiceReference[] references;
            String osgiFilter = url.substring(OSGI.length());
            String clazz = null;
            String filter = null;
            String[] tokens = osgiFilter.split("/", 2);
            if (tokens != null) {
                if (tokens.length > 0) {
                    clazz = tokens[0];
                }
                if (tokens.length > 1) {
                    filter = tokens[1];
                }
            }
            if ((references = this.bundleContext.getServiceReferences(clazz, filter)) != null) {
                ServiceReference ref = references[0];
                Object ds = this.bundleContext.getService(ref);
                this.bundleContext.ungetService(ref);
                return ds;
            }
            throw new Exception("Unable to find service reference for datasource: " + clazz + "/" + filter);
        }
        throw new Exception("Illegal datasource url format");
    }

    @Override
    public boolean login() throws LoginException {
        Connection connection = null;
        Statement passwordStatement = null;
        Statement roleStatement = null;
        ResultSet passwordResultSet = null;
        ResultSet roleResultSet = null;
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        String password = new String(tmpPassword);
        this.principals = new HashSet();
        try {
            Object credentialsDatasource = this.createDatasource(this.datasourceURL);
            if (credentialsDatasource == null) {
                throw new LoginException("Cannot obtain data source:" + this.datasourceURL);
            }
            if (credentialsDatasource instanceof DataSource) {
                connection = ((DataSource)credentialsDatasource).getConnection();
            } else if (credentialsDatasource instanceof XADataSource) {
                connection = ((XADataSource)credentialsDatasource).getXAConnection().getConnection();
            } else {
                throw new LoginException("Unknow dataSource type " + credentialsDatasource.getClass());
            }
            passwordStatement = connection.prepareStatement(this.passwordQuery);
            passwordStatement.setString(1, this.user);
            passwordResultSet = passwordStatement.executeQuery();
            if (!passwordResultSet.next()) {
                throw new LoginException("User " + this.user + " does not exist");
            }
            String storedPassword = passwordResultSet.getString(1);
            if (!this.checkPassword(password, storedPassword)) {
                throw new LoginException("Password for " + this.user + " does not match");
            }
            this.principals.add(new UserPrincipal(this.user));
            roleStatement = connection.prepareStatement(this.roleQuery);
            roleStatement.setString(1, this.user);
            roleResultSet = roleStatement.executeQuery();
            while (roleResultSet.next()) {
                String role = roleResultSet.getString(1);
                this.principals.add(new RolePrincipal(role));
            }
        }
        catch (Exception ex) {
            throw new LoginException("Error has occured while retrieving credentials from database:" + ex.getMessage());
        }
        finally {
            try {
                if (passwordResultSet != null) {
                    passwordResultSet.close();
                }
                if (passwordStatement != null) {
                    passwordStatement.close();
                }
                if (roleResultSet != null) {
                    roleResultSet.close();
                }
                if (roleStatement != null) {
                    roleStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ex) {
                LOG.warn((Object)"Failed to clearly close connection to the database:", (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.debug((Object)"logout");
        }
        return true;
    }
}

