/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.tooling.features;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class CustomBundleURLStreamHandlerFactory implements
		URLStreamHandlerFactory {
	private static final String MVN_URI_PREFIX = "mvn";
	private static final String WRAP_URI_PREFIX = "wrap";
    private static final String FEATURE_URI_PREFIX = "feature";
    private static final String SPRING_URI_PREFIX = "spring";
    private static final String BLUEPRINT_URI_PREFIX = "blueprint";
	
	public URLStreamHandler createURLStreamHandler(String protocol) {
		if (protocol.equals(MVN_URI_PREFIX)) {
			return new org.ops4j.pax.url.mvn.Handler();
		} else if (protocol.equals(WRAP_URI_PREFIX)){
			return new org.ops4j.pax.url.wrap.Handler();
		} else if (protocol.equals(FEATURE_URI_PREFIX)){
			return new FeatureURLHandler();
		} else if (protocol.equals(SPRING_URI_PREFIX)){
			return new SpringURLHandler();
		} else if (protocol.equals(BLUEPRINT_URI_PREFIX)){
			return new BlueprintURLHandler();
		} else {
			return null;
		}
	}

}
