/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.packages;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.packages.PackageCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="packages", name="imports", description="Display imported packages")
public class ImportsCommand
extends PackageCommandSupport {
    @Argument(index=0, name="ids", description="The IDs of bundles to check", required=false, multiValued=true)
    List<Long> ids;
    @Option(name="-i", aliases={"--show-importer"}, description="show the bundle that is importing a package", required=false, multiValued=false)
    private boolean showImporter;

    @Override
    protected void doExecute(PackageAdmin admin) throws Exception {
        ExportedPackage[] exported;
        HashMap<Long, List<ExportedPackage>> packages = new HashMap<Long, List<ExportedPackage>>();
        for (ExportedPackage pkg : exported = admin.getExportedPackages((Bundle)null)) {
            Bundle[] bundles = pkg.getImportingBundles();
            if (bundles == null) continue;
            for (Bundle b : bundles) {
                ArrayList<ExportedPackage> p = (ArrayList<ExportedPackage>)packages.get(b.getBundleId());
                if (p == null) {
                    p = new ArrayList<ExportedPackage>();
                    packages.put(b.getBundleId(), p);
                }
                p.add(pkg);
            }
        }
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle != null) {
                    this.printImports(System.out, bundle, (List)packages.get(bundle.getBundleId()));
                    continue;
                }
                System.err.println("Bundle ID " + id + " is invalid.");
            }
        } else if (this.showImporter) {
            this.printImports(System.out, packages);
        } else {
            ArrayList<ExportedPackage> pkgs = new ArrayList<ExportedPackage>();
            for (List l : packages.values()) {
                pkgs.addAll(l);
            }
            this.printImports(System.out, null, pkgs);
        }
    }

    protected void printImports(PrintStream out, Map<Long, List<ExportedPackage>> imports) {
        for (Map.Entry<Long, List<ExportedPackage>> entry : imports.entrySet()) {
            for (ExportedPackage p : entry.getValue()) {
                Bundle importer = this.getBundleContext().getBundle(entry.getKey().longValue());
                out.print(ImportsCommand.getBundleName(importer));
                out.print(" imports: ");
                Bundle exporter = p.getExportingBundle();
                out.print(ImportsCommand.getBundleName(exporter));
                out.println(": " + p);
            }
        }
    }

    protected void printImports(PrintStream out, Bundle target, List<ExportedPackage> imports) {
        if (imports != null && imports.size() > 0) {
            for (ExportedPackage p : imports) {
                Bundle bundle = p.getExportingBundle();
                out.print(ImportsCommand.getBundleName(bundle));
                out.println(": " + p);
            }
        } else {
            out.println(ImportsCommand.getBundleName(target) + ": No active imported packages.");
        }
    }

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }
}

