/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.config.ConfigCommandSupport;
import org.apache.karaf.util.Properties;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="update", description="Save and propagate changes from the configuration being edited.")
public class UpdateCommand
extends ConfigCommandSupport {
    @Option(name="-b", aliases={"--bypass-storage"}, multiValued=false, required=false, description="Do not store the configuration in a properties file, but feed it directly to ConfigAdmin")
    private boolean bypassStorage;
    private File storage;

    public File getStorage() {
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Dictionary props = this.getEditedProps();
        if (props == null) {
            System.err.println("No configuration is being edited. Run the edit command first");
        } else if (!this.bypassStorage && this.storage != null) {
            String pid = (String)this.session.get("ConfigCommand.PID");
            File storageFile = new File(this.storage, pid + ".cfg");
            Properties p = new Properties(storageFile);
            Enumeration keys = props.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if ("service.pid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                p.put((String)key, (String)props.get(key));
            }
            this.storage.mkdirs();
            p.save();
            this.session.put("ConfigCommand.PID", null);
            this.session.put("ConfigCommand.Props", null);
        } else {
            String pid = (String)this.session.get("ConfigCommand.PID");
            Configuration cfg = admin.getConfiguration(pid, null);
            cfg.update(props);
            this.session.put("ConfigCommand.PID", null);
            this.session.put("ConfigCommand.Props", null);
        }
    }
}

