/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.log;

import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.log.LruList;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="display-exception", description="Displays the last occured exception from the log.")
public class DisplayException
extends OsgiCommandSupport {
    protected LruList events;

    public LruList getEvents() {
        return this.events;
    }

    public void setEvents(LruList events) {
        this.events = events;
    }

    protected Object doExecute() throws Exception {
        PaxLoggingEvent throwableEvent = null;
        Iterable<PaxLoggingEvent> le = this.events.getElements(Integer.MAX_VALUE);
        for (PaxLoggingEvent event : le) {
            if (event.getThrowableStrRep() == null) continue;
            throwableEvent = event;
        }
        if (throwableEvent != null) {
            for (String r : throwableEvent.getThrowableStrRep()) {
                System.out.println(r);
            }
            System.out.println();
        }
        return null;
    }
}

