/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.shell;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.gogo.runtime.shell.Command;
import org.apache.felix.gogo.runtime.shell.CommandSessionImpl;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;
import org.osgi.service.command.Converter;
import org.osgi.service.command.Function;
import org.osgi.service.threadio.ThreadIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandShellImpl
implements CommandProcessor {
    Set<Converter> converters = new HashSet<Converter>();
    protected ThreadIO threadIO;
    public static final Object NO_SUCH_COMMAND = new Object();
    Map<String, Object> commands = new LinkedHashMap<String, Object>();

    public CommandShellImpl() {
        this.addCommand("shell", (Object)this, "addCommand");
        this.addCommand("shell", (Object)this, "removeCommand");
    }

    @Override
    public CommandSession createSession(InputStream in, PrintStream out, PrintStream err) {
        return new CommandSessionImpl(this, in, out, err);
    }

    public void setThreadio(ThreadIO threadIO) {
        this.threadIO = threadIO;
    }

    public void setConverter(Converter c) {
        this.converters.add(c);
    }

    public void unsetConverter(Converter c) {
        this.converters.remove(c);
    }

    public Object get(String name) {
        if (name == null) {
            return this.commands.keySet();
        }
        int n = (name = name.toLowerCase()).indexOf(58);
        if (n < 0) {
            return null;
        }
        String function = name.substring(n);
        Object cmd = null;
        if (this.commands.containsKey(name)) {
            cmd = this.commands.get(name);
        } else {
            String scope = name.substring(0, n);
            if (scope.equals("*")) {
                for (Map.Entry<String, Object> entry : this.commands.entrySet()) {
                    if (!entry.getKey().endsWith(function)) continue;
                    cmd = entry.getValue();
                    break;
                }
            }
            if (cmd == null && name.equals(":")) {
                return Collections.unmodifiableSet(this.commands.keySet());
            }
        }
        if (cmd == null) {
            return null;
        }
        if (cmd instanceof Function) {
            return cmd;
        }
        return new Command(cmd, function.substring(1));
    }

    public void addCommand(String scope, Object target) {
        Class<?> tc = target instanceof Class ? (Class<?>)target : target.getClass();
        this.addCommand(scope, target, tc);
    }

    public void addCommand(String scope, Object target, Class<?> functions) {
        String[] names;
        if (target == null) {
            return;
        }
        for (String function : names = this.getFunctions(functions)) {
            this.addCommand(scope, target, function);
        }
    }

    public void addCommand(String scope, Object target, String function) {
        this.commands.put((scope + ":" + function).toLowerCase(), target);
    }

    public void removeCommand(String scope, String function) {
        String func = (scope + ":" + function).toLowerCase();
        this.commands.remove(func);
    }

    public void removeCommand(Object target) {
        Iterator<Object> i = this.commands.values().iterator();
        while (i.hasNext()) {
            if (i.next() != target) continue;
            i.remove();
        }
    }

    private String[] getFunctions(Class<?> target) {
        Method[] methods;
        TreeSet<String> list = new TreeSet<String>();
        for (Method m : methods = target.getMethods()) {
            String s;
            if (m.getDeclaringClass().equals(Object.class)) continue;
            list.add(m.getName());
            if (!m.getName().startsWith("get") || (s = m.getName().substring(3)).length() <= 0) continue;
            list.add(s.substring(0, 1).toLowerCase() + s.substring(1));
        }
        String[] functions = list.toArray(new String[list.size()]);
        return functions;
    }

    protected void put(String name, Object target) {
        this.commands.put(name, target);
    }

    public Object convert(Class<?> desiredType, Object in) {
        for (Converter c : this.converters) {
            try {
                Object converted = c.convert(desiredType, in);
                if (converted == null) continue;
                return converted;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

