/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.EnumSet;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="install", description="Installs a feature with the specified name and version.")
public class InstallFeatureCommand
extends FeaturesCommandSupport {
    private static String DEFAULT_VERSION = "0.0.0";
    @Argument(index=0, name="name", description="The name of the feature", required=true, multiValued=false)
    String name;
    @Argument(index=1, name="version", description="The version of the feature", required=false, multiValued=false)
    String version;
    @Option(name="-c", aliases={"--no-clean"}, description="Do not uninstall bundles on failure", required=false, multiValued=false)
    boolean noClean;
    @Option(name="-r", aliases={"--no-auto-refresh"}, description="Do not automatically refresh bundles", required=false, multiValued=false)
    boolean noRefresh;

    protected void doExecute(FeaturesService admin) throws Exception {
        if (this.version == null || this.version.length() == 0) {
            this.version = DEFAULT_VERSION;
        }
        EnumSet<FeaturesService.Option> options = EnumSet.of(FeaturesService.Option.PrintBundlesToRefresh);
        if (this.noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        if (this.noClean) {
            options.add(FeaturesService.Option.NoCleanIfFailure);
        }
        admin.installFeature(this.name, this.version, options);
    }
}

