/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.io.File;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.dev.framework.Equinox;
import org.apache.karaf.shell.dev.framework.Felix;
import org.apache.karaf.shell.dev.framework.Framework;
import org.apache.karaf.util.Properties;

@Command(scope="dev", name="framework", description="OSGi Framework options")
public class FrameworkOptions
extends OsgiCommandSupport {
    private static final String KARAF_BASE = System.getProperty("karaf.base");
    @Option(name="-debug", aliases={"--enable-debug"}, description="Enable debug for the OSGi framework", required=false, multiValued=false)
    boolean debug;
    @Option(name="-nodebug", aliases={"--disable-debug"}, description="Disable debug for the OSGi framework", required=false, multiValued=false)
    boolean nodebug;
    @Argument(name="framework", required=false, description="Name of the OSGi framework to use")
    String framework;

    protected Object doExecute() throws Exception {
        Framework frwk;
        if (!this.debug ^ this.nodebug && this.framework == null) {
            System.out.printf("Current OSGi framework is %s%n", this.getFramework().getName());
            return null;
        }
        if (this.debug) {
            frwk = this.getFramework();
            System.out.printf("Enabling debug for OSGi framework (%s)%n", frwk.getName());
            frwk.enableDebug(new File(KARAF_BASE));
        }
        if (this.nodebug) {
            frwk = this.getFramework();
            System.out.printf("Disabling debug for OSGi framework (%s)%n", frwk.getName());
            frwk.disableDebug(new File(KARAF_BASE));
        }
        if (this.framework != null) {
            if (!"Felix".equalsIgnoreCase(this.framework) && !"Equinox".equalsIgnoreCase(this.framework)) {
                System.err.printf("Unsupported framework: %s%n", this.framework);
                return null;
            }
            Properties props = new Properties(new File(System.getProperty("karaf.base"), "etc/config.properties"));
            props.put("karaf.framework", this.framework.toLowerCase());
            props.save();
        }
        return null;
    }

    public Framework getFramework() {
        if (this.bundleContext.getBundle(0L).getSymbolicName().contains("felix")) {
            return new Felix(new File(KARAF_BASE));
        }
        return new Equinox(new File(KARAF_BASE));
    }
}

