/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.karaf.jaas.modules.Encryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEncryption
implements Encryption {
    private static final Logger log = LoggerFactory.getLogger(BasicEncryption.class);
    private String algorithm;
    private String encoding;
    private MessageDigest md;
    private static final byte[] hexTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte padding = (byte)61;

    public BasicEncryption(Map<String, String> params) {
        for (String key : params.keySet()) {
            if ("algorithm".equalsIgnoreCase(key)) {
                this.algorithm = params.get(key);
                continue;
            }
            if ("encoding".equalsIgnoreCase(key)) {
                this.encoding = params.get(key);
                continue;
            }
            throw new IllegalArgumentException("Unsupported encryption parameter: " + key);
        }
        if (this.algorithm == null) {
            throw new IllegalArgumentException("Digest algorithm must be specified");
        }
        try {
            this.md = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Initialization failed. Digest algorithm " + this.algorithm + " is not available.", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure login module: " + e.getMessage(), e);
        }
        if (this.encoding != null && this.encoding.length() > 0 && !"hexadecimal".equalsIgnoreCase(this.encoding) && !"base64".equalsIgnoreCase(this.encoding)) {
            log.error("Initialization failed. Digest encoding " + this.encoding + " is not supported.");
            throw new IllegalArgumentException("Unable to configure login module. Digest Encoding " + this.encoding + " not supported.");
        }
    }

    @Override
    public String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        byte[] data = this.md.digest(password.getBytes());
        if (this.encoding == null || this.encoding.length() == 0 || "hexadecimal".equalsIgnoreCase(this.encoding)) {
            return BasicEncryption.hexEncode(data);
        }
        if ("base64".equalsIgnoreCase(this.encoding)) {
            return BasicEncryption.base64Encode(data);
        }
        throw new IllegalArgumentException("Unable to configure login module. Digest Encoding " + this.encoding + " not supported.");
    }

    @Override
    public boolean checkPassword(String provided, String real) {
        if (real == null && provided == null) {
            return true;
        }
        if (real == null || provided == null) {
            return false;
        }
        String encoded = this.encryptPassword(provided);
        if (this.encoding == null || this.encoding.length() == 0 || "hexadecimal".equalsIgnoreCase(this.encoding)) {
            return real.equalsIgnoreCase(encoded);
        }
        if ("base64".equalsIgnoreCase(this.encoding)) {
            return real.equals(encoded);
        }
        return false;
    }

    public static String hexEncode(byte[] in) {
        int inOff = 0;
        int length = in.length;
        byte[] out = new byte[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            out[j] = hexTable[in[inOff] >> 4 & 0xF];
            out[j + 1] = hexTable[in[inOff] & 0xF];
            ++inOff;
            ++i;
            j += 2;
        }
        return new String(out);
    }

    public static String base64Encode(byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            BasicEncryption.base64Encode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception encoding base64 string: " + e.getMessage(), e);
        }
        return new String(bOut.toByteArray());
    }

    public static int base64Encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int modulus = length % 3;
        int dataLength = length - modulus;
        for (int i = off; i < off + dataLength; i += 3) {
            int a1 = data[i] & 0xFF;
            int a2 = data[i + 1] & 0xFF;
            int a3 = data[i + 2] & 0xFF;
            out.write(encodingTable[a1 >>> 2 & 0x3F]);
            out.write(encodingTable[(a1 << 4 | a2 >>> 4) & 0x3F]);
            out.write(encodingTable[(a2 << 2 | a3 >>> 6) & 0x3F]);
            out.write(encodingTable[a3 & 0x3F]);
        }
        switch (modulus) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data[off + dataLength] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = d1 << 4 & 0x3F;
                out.write(encodingTable[b1]);
                out.write(encodingTable[b2]);
                out.write(padding);
                out.write(padding);
                break;
            }
            case 2: {
                int d1 = data[off + dataLength] & 0xFF;
                int d2 = data[off + dataLength + 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = (d1 << 4 | d2 >>> 4) & 0x3F;
                int b3 = d2 << 2 & 0x3F;
                out.write(encodingTable[b1]);
                out.write(encodingTable[b2]);
                out.write(encodingTable[b3]);
                out.write(padding);
            }
        }
        return dataLength / 3 * 4 + (modulus == 0 ? 0 : 4);
    }
}

