/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.config.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.karaf.jaas.config.KeystoreInstance;
import org.apache.karaf.jaas.config.KeystoreIsLocked;

public class ResourceKeystoreInstance
implements KeystoreInstance {
    private static final Log LOG = LogFactory.getLog(ResourceKeystoreInstance.class);
    private static final String JKS = "JKS";
    private String name;
    private int rank;
    private URL path;
    private String keystorePassword;
    private Map keyPasswords = new HashMap();
    private File keystoreFile;
    private List privateKeys = new ArrayList();
    private List trustCerts = new ArrayList();
    private KeyStore keystore;
    private long keystoreReadDate = Long.MIN_VALUE;

    public String getName() {
        return this.name;
    }

    public void setName(String keystoreName) {
        this.name = keystoreName;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public URL getPath() {
        return this.path;
    }

    public void setPath(URL keystorePath) throws IOException {
        this.path = keystorePath;
        if (keystorePath.getProtocol().equals("file")) {
            URI uri = URI.create(keystorePath.toString().replace(" ", "%20"));
            this.keystoreFile = new File(uri.getSchemeSpecificPart());
        }
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setKeyPasswords(String keyPasswords) {
        if (keyPasswords != null) {
            String[] keys = keyPasswords.split("\\]\\!\\[");
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                int pos = key.indexOf(61);
                this.keyPasswords.put(key.substring(0, pos), key.substring(pos + 1).toCharArray());
            }
        }
    }

    public Certificate getCertificate(String alias) {
        if (!this.loadKeystoreData()) {
            return null;
        }
        try {
            return this.keystore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            LOG.error((Object)"Unable to read certificate from keystore", (Throwable)e);
            return null;
        }
    }

    public String getCertificateAlias(Certificate cert) {
        if (!this.loadKeystoreData()) {
            return null;
        }
        try {
            return this.keystore.getCertificateAlias(cert);
        }
        catch (KeyStoreException e) {
            LOG.error((Object)"Unable to read retrieve alias for given certificate from keystore", (Throwable)e);
            return null;
        }
    }

    public Certificate[] getCertificateChain(String alias) {
        if (!this.loadKeystoreData()) {
            return null;
        }
        try {
            return this.keystore.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            LOG.error((Object)"Unable to read certificate chain from keystore", (Throwable)e);
            return null;
        }
    }

    public KeyManager[] getKeyManager(String algorithm, String keyAlias) throws KeystoreIsLocked, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        if (this.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + this.name + "' is locked.");
        }
        if (!this.loadKeystoreData()) {
            return null;
        }
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(algorithm);
        keyFactory.init(this.keystore, (char[])this.keyPasswords.get(keyAlias));
        return keyFactory.getKeyManagers();
    }

    public PrivateKey getPrivateKey(String alias) {
        if (!this.loadKeystoreData()) {
            return null;
        }
        try {
            if (this.isKeyLocked(alias)) {
                return null;
            }
            Key key = this.keystore.getKey(alias, (char[])this.keyPasswords.get(alias));
            if (key instanceof PrivateKey) {
                return (PrivateKey)key;
            }
        }
        catch (KeyStoreException e) {
            LOG.error((Object)"Unable to read private key from keystore", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Unable to read private key from keystore", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            LOG.error((Object)"Unable to read private key from keystore", (Throwable)e);
        }
        return null;
    }

    public TrustManager[] getTrustManager(String algorithm) throws KeyStoreException, NoSuchAlgorithmException, KeystoreIsLocked {
        if (this.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + this.name + "' is locked.");
        }
        if (!this.loadKeystoreData()) {
            return null;
        }
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(algorithm);
        trustFactory.init(this.keystore);
        return trustFactory.getTrustManagers();
    }

    public boolean isKeyLocked(String keyAlias) {
        return this.keyPasswords.get(keyAlias) == null;
    }

    public boolean isKeystoreLocked() {
        return this.keystorePassword == null;
    }

    public String[] listPrivateKeys() {
        if (!this.loadKeystoreData()) {
            return null;
        }
        return this.privateKeys.toArray(new String[this.privateKeys.size()]);
    }

    public String[] listTrustCertificates() {
        if (!this.loadKeystoreData()) {
            return null;
        }
        return this.trustCerts.toArray(new String[this.trustCerts.size()]);
    }

    private boolean loadKeystoreData() {
        if (this.keystoreFile != null && this.keystoreReadDate >= this.keystoreFile.lastModified()) {
            return true;
        }
        if (this.keystoreFile == null && this.keystore != null) {
            return true;
        }
        if (!(this.keystoreFile == null || this.keystoreFile.exists() && this.keystoreFile.canRead())) {
            throw new IllegalArgumentException("Invalid keystore file (" + this.path + " = " + this.keystoreFile.getAbsolutePath() + ")");
        }
        try {
            this.keystoreReadDate = System.currentTimeMillis();
            this.privateKeys.clear();
            this.trustCerts.clear();
            if (this.keystore == null) {
                this.keystore = KeyStore.getInstance(JKS);
            }
            BufferedInputStream in = new BufferedInputStream(this.path.openStream());
            this.keystore.load(in, this.keystorePassword == null ? new char[]{} : this.keystorePassword.toCharArray());
            ((InputStream)in).close();
            Enumeration<String> aliases = this.keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (this.keystore.isKeyEntry(alias)) {
                    this.privateKeys.add(alias);
                    continue;
                }
                if (!this.keystore.isCertificateEntry(alias)) continue;
                this.trustCerts.add(alias);
            }
            return true;
        }
        catch (KeyStoreException e) {
            LOG.error((Object)"Unable to open keystore with provided password", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to open keystore with provided password", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Unable to open keystore with provided password", (Throwable)e);
        }
        catch (CertificateException e) {
            LOG.error((Object)"Unable to open keystore with provided password", (Throwable)e);
        }
        return false;
    }
}

