/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureImpl
implements Feature {
    private String id;
    private String name;
    private String version;
    private String resolver;
    private List<Feature> dependencies = new ArrayList<Feature>();
    private List<BundleInfo> bundles = new ArrayList<BundleInfo>();
    private Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
    public static String SPLIT_FOR_NAME_AND_VERSION = "_split_for_name_and_version_";
    public static String DEFAULT_VERSION = "0.0.0";
    public static String VERSION_PREFIX = "version=";

    public FeatureImpl() {
    }

    public FeatureImpl(String name) {
        this(name, DEFAULT_VERSION);
    }

    public FeatureImpl(String name, String version) {
        this.name = name;
        this.version = version;
        this.id = name + "-" + version;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    @Override
    public List<Feature> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<BundleInfo> getBundles() {
        return this.bundles;
    }

    @Override
    public Map<String, Map<String, String>> getConfigurations() {
        return this.configs;
    }

    public void addDependency(Feature dependency) {
        this.dependencies.add(dependency);
    }

    public void addBundle(BundleInfo bundle) {
        this.bundles.add(bundle);
    }

    public void addConfig(String name, Map<String, String> properties) {
        this.configs.put(name, properties);
    }

    public String toString() {
        String ret = this.getName() + SPLIT_FOR_NAME_AND_VERSION + this.getVersion();
        return ret;
    }

    public static Feature valueOf(String str) {
        if (str.indexOf(SPLIT_FOR_NAME_AND_VERSION) >= 0) {
            String strName = str.substring(0, str.indexOf(SPLIT_FOR_NAME_AND_VERSION));
            String strVersion = str.substring(str.indexOf(SPLIT_FOR_NAME_AND_VERSION) + SPLIT_FOR_NAME_AND_VERSION.length(), str.length());
            return new FeatureImpl(strName, strVersion);
        }
        return new FeatureImpl(str);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureImpl feature = (FeatureImpl)o;
        if (!this.name.equals(feature.name)) {
            return false;
        }
        return this.version.equals(feature.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

