/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FeatureDeploymentListener
implements ArtifactUrlTransformer,
BundleListener {
    public static final String FEATURE_PATH = "org.apache.karaf.shell.features";
    private static final Log LOGGER = LogFactory.getLog(FeatureDeploymentListener.class);
    private DocumentBuilderFactory dbf;
    private FeaturesService featuresService;
    private BundleContext bundleContext;

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32) continue;
            this.bundleChanged(new BundleEvent(32, bundle));
        }
    }

    public void destroy() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public boolean canHandle(File artifact) {
        try {
            if (artifact.isFile() && artifact.getName().endsWith(".xml")) {
                Document doc = this.parse(artifact);
                String name = doc.getDocumentElement().getLocalName();
                String uri = doc.getDocumentElement().getNamespaceURI();
                if ("features".equals(name) && (uri == null || "".equals(uri))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unable to parse deployed file " + artifact.getAbsolutePath()), (Throwable)e);
        }
        return false;
    }

    public URL transform(URL artifact) {
        try {
            return new URL("feature", null, artifact.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to build feature bundle", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        if (bundleEvent.getType() == 32) {
            try {
                Object url;
                ArrayList<Object> urls = new ArrayList<Object>();
                Enumeration featuresUrlEnumeration = bundle.findEntries("/META-INF/org.apache.karaf.shell.features/", "*.xml", false);
                while (featuresUrlEnumeration != null && featuresUrlEnumeration.hasMoreElements()) {
                    url = (URL)featuresUrlEnumeration.nextElement();
                    try {
                        this.featuresService.addRepository(((URL)url).toURI());
                        for (Repository repo : this.featuresService.listRepositories()) {
                            if (!repo.getURI().equals(((URL)url).toURI())) continue;
                            HashSet<Feature> features = new HashSet<Feature>(Arrays.asList(repo.getFeatures()));
                            this.featuresService.installFeatures(features, EnumSet.noneOf(FeaturesService.Option.class));
                        }
                        urls.add(url);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Unable to install features", (Throwable)e);
                    }
                }
                url = this;
                synchronized (url) {
                    File file = this.bundleContext.getDataFile("FeatureDeploymentListener.cfg");
                    if (file != null) {
                        Properties props = new Properties();
                        if (file.exists()) {
                            FileInputStream input = new FileInputStream(file);
                            try {
                                props.load(input);
                            }
                            finally {
                                ((InputStream)input).close();
                            }
                        }
                        String prefix = bundle.getSymbolicName() + "-" + bundle.getVersion();
                        props.put(prefix + ".count", Integer.toString(urls.size()));
                        for (int i = 0; i < urls.size(); ++i) {
                            props.put(prefix + ".url." + i, ((URL)urls.get(i)).toExternalForm());
                        }
                        FileOutputStream output = new FileOutputStream(file);
                        try {
                            props.store(output, null);
                        }
                        finally {
                            ((OutputStream)output).close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to install deployed features for bundle: " + bundle.getSymbolicName() + " - " + bundle.getVersion()), (Throwable)e);
            }
        } else if (bundleEvent.getType() == 16) {
            try {
                FeatureDeploymentListener e = this;
                synchronized (e) {
                    File file = this.bundleContext.getDataFile("FeatureDeploymentListener.cfg");
                    if (file != null) {
                        String prefix;
                        String countStr;
                        Properties props = new Properties();
                        if (file.exists()) {
                            FileInputStream input = new FileInputStream(file);
                            try {
                                props.load(input);
                            }
                            finally {
                                ((InputStream)input).close();
                            }
                        }
                        if ((countStr = (String)props.get((prefix = bundle.getSymbolicName() + "-" + bundle.getVersion()) + ".count")) != null) {
                            int count = Integer.parseInt(countStr);
                            for (int i = 0; i < count; ++i) {
                                URL url = new URL((String)props.get(prefix + ".url." + i));
                                for (Repository repo : this.featuresService.listRepositories()) {
                                    try {
                                        if (!repo.getURI().equals(url.toURI())) continue;
                                        for (Feature f : repo.getFeatures()) {
                                            try {
                                                this.featuresService.uninstallFeature(f.getName(), f.getVersion());
                                            }
                                            catch (Exception e2) {
                                                LOGGER.error((Object)("Unable to uninstall feature: " + f.getName()), (Throwable)e2);
                                            }
                                        }
                                    }
                                    catch (Exception e3) {
                                        LOGGER.error((Object)("Unable to uninstall features: " + url), (Throwable)e3);
                                    }
                                }
                                try {
                                    this.featuresService.removeRepository(url.toURI());
                                    continue;
                                }
                                catch (URISyntaxException e4) {
                                    LOGGER.error((Object)("Unable to remove repository: " + url), (Throwable)e4);
                                }
                            }
                        }
                        Iterator<Object> it = props.keySet().iterator();
                        while (it.hasNext()) {
                            if (!it.next().toString().startsWith(prefix + ".")) continue;
                            it.remove();
                        }
                        FileOutputStream output = new FileOutputStream(file);
                        try {
                            props.store(output, null);
                        }
                        finally {
                            ((OutputStream)output).close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to uninstall deployed features for bundle: " + bundle.getSymbolicName() + " - " + bundle.getVersion()), (Throwable)e);
            }
        }
    }

    protected Document parse(File artifact) throws Exception {
        if (this.dbf == null) {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.dbf.setNamespaceAware(true);
        }
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return db.parse(artifact);
    }
}

