/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.service.internal.PaxLoggerImpl;

public class JdkHandler
extends Handler {
    private PaxLoggingService m_logService;

    public JdkHandler(PaxLoggingService logService) {
        this.m_logService = logService;
        this.setFormatter(new SimpleFormatter());
    }

    public void close() throws SecurityException {
    }

    public void flush() {
    }

    public void publish(LogRecord record) {
        String message;
        Level level = record.getLevel();
        if (level.intValue() == Level.CONFIG.intValue()) {
            return;
        }
        String loggerName = record.getLoggerName();
        String fqcn = Logger.class.getName();
        PaxLoggerImpl logger = (PaxLoggerImpl)this.m_logService.getLogger(null, loggerName, fqcn);
        try {
            message = this.getFormatter().formatMessage(record);
        }
        catch (Exception ex) {
            message = record.getMessage();
        }
        Throwable throwable = record.getThrown();
        org.apache.log4j.Level log4jlevel = level == Level.OFF ? org.apache.log4j.Level.OFF : (level == Level.FINE ? org.apache.log4j.Level.DEBUG : (level == Level.FINER || level == Level.FINEST ? org.apache.log4j.Level.TRACE : (level == Level.INFO ? org.apache.log4j.Level.INFO : (level == Level.WARNING ? org.apache.log4j.Level.WARN : (level == Level.SEVERE ? org.apache.log4j.Level.ERROR : org.apache.log4j.Level.INFO)))));
        logger.log(log4jlevel, message, throwable);
    }
}

