/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.EncryptionService;
import org.apache.karaf.jaas.modules.RolePolicy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class AbstractKarafLoginModule
implements LoginModule {
    protected Set<Principal> principals = new HashSet<Principal>();
    protected Subject subject;
    protected String user;
    protected CallbackHandler callbackHandler;
    protected boolean debug;
    protected Map<String, ?> options;
    protected String rolePolicy;
    protected String roleDiscriminator;
    protected BundleContext bundleContext;
    private Encryption encryption;
    private String encryptionPrefix;
    private String encryptionSuffix;
    private static final Log LOG = LogFactory.getLog(AbstractKarafLoginModule.class);

    public boolean commit() throws LoginException {
        RolePolicy policy = RolePolicy.getPolicy(this.rolePolicy);
        if (policy != null && this.roleDiscriminator != null) {
            policy.handleRoles(this.subject, this.principals, this.roleDiscriminator);
        } else {
            this.subject.getPrincipals().addAll(this.principals);
        }
        return true;
    }

    protected void clear() {
        this.user = null;
    }

    public void initialize(Subject sub, CallbackHandler handler, Map options) {
        this.subject = sub;
        this.callbackHandler = handler;
        this.options = options;
        this.rolePolicy = (String)options.get("role.policy");
        this.roleDiscriminator = (String)options.get("role.discriminator");
        this.debug = Boolean.parseBoolean((String)options.get("debug"));
        this.bundleContext = (BundleContext)options.get(BundleContext.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Encryption getEncryption() {
        if (this.encryption == null) {
            HashMap<String, String> encOpts = new HashMap<String, String>();
            for (String key : this.options.keySet()) {
                if (!key.startsWith("encryption.")) continue;
                encOpts.put(key.substring("encryption.".length()), this.options.get(key).toString());
            }
            this.encryptionPrefix = (String)encOpts.remove("prefix");
            this.encryptionSuffix = (String)encOpts.remove("suffix");
            boolean enabled = Boolean.parseBoolean((String)encOpts.remove("enabled"));
            if (!enabled) {
                if (this.debug) {
                    LOG.debug((Object)"Encryption is disabled.");
                }
            } else {
                Object[] encryptionServiceReferences;
                String name = (String)encOpts.remove("name");
                if (this.debug) {
                    if (name != null && name.length() > 0) {
                        LOG.debug((Object)("Encryption is enabled. Using service " + name + " with options " + encOpts));
                    } else {
                        LOG.debug((Object)("Encryption is enabled. Using options " + encOpts));
                    }
                }
                try {
                    encryptionServiceReferences = this.bundleContext.getServiceReferences(EncryptionService.class.getName(), name != null && name.length() > 0 ? "(name=" + name + ")" : null);
                }
                catch (InvalidSyntaxException e) {
                    throw new IllegalStateException("The encryption service filter is not well formed.", e);
                }
                if (encryptionServiceReferences.length == 0) {
                    if (name != null && name.length() > 0) {
                        throw new IllegalStateException("Encryption service " + name + " not found. Please check that the encryption service is correctly set up.");
                    }
                    throw new IllegalStateException("No encryption service found. Please install the Karaf encryption feature and check that the encryption algorithm is supported..");
                }
                Arrays.sort(encryptionServiceReferences);
                for (Object ref : encryptionServiceReferences) {
                    try {
                        EncryptionService encryptionService = (EncryptionService)this.bundleContext.getService((ServiceReference)ref);
                        if (encryptionService == null) continue;
                        try {
                            this.encryption = encryptionService.createEncryption(encOpts);
                            if (this.encryption == null) continue;
                            break;
                        }
                        finally {
                            this.bundleContext.ungetService((ServiceReference)ref);
                        }
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
                if (this.encryption == null) {
                    throw new IllegalStateException("No EncryptionService supporting the required options could be found.");
                }
            }
        }
        return this.encryption;
    }

    public String getEncryptedPassword(String password) {
        boolean suffix;
        Encryption encryption = this.getEncryption();
        if (encryption == null) {
            return password;
        }
        boolean prefix = this.encryptionPrefix == null || password.startsWith(this.encryptionPrefix);
        boolean bl = suffix = this.encryptionSuffix == null || password.endsWith(this.encryptionSuffix);
        if (prefix && suffix) {
            return password;
        }
        String p = encryption.encryptPassword(password);
        if (this.encryptionPrefix != null) {
            p = this.encryptionPrefix + p;
        }
        if (this.encryptionSuffix != null) {
            p = p + this.encryptionSuffix;
        }
        return p;
    }

    public boolean checkPassword(String plain, String encrypted) {
        boolean suffix;
        Encryption encryption = this.getEncryption();
        if (encryption == null) {
            return plain.equals(encrypted);
        }
        boolean prefix = this.encryptionPrefix == null || encrypted.startsWith(this.encryptionPrefix);
        boolean bl = suffix = this.encryptionSuffix == null || encrypted.endsWith(this.encryptionSuffix);
        if (prefix && suffix) {
            encrypted = encrypted.substring(this.encryptionPrefix != null ? this.encryptionPrefix.length() : 0, encrypted.length() - (this.encryptionSuffix != null ? this.encryptionSuffix.length() : 0));
            return encryption.checkPassword(plain, encrypted);
        }
        return plain.equals(encrypted);
    }
}

