/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundlesCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="ids", description="The list of bundle IDs separated by whitespaces", required=true, multiValued=true)
    List<Long> ids;
    @Option(name="--force", aliases={}, description="Forces the command to execute", required=false, multiValued=false)
    boolean force;

    protected Object doExecute() throws Exception {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle == null) {
                    System.err.println("Bundle ID" + id + " is invalid");
                    continue;
                }
                if (!this.force && Util.isASystemBundle(this.getBundleContext(), bundle) && !Util.accessToSystemBundleIsAllowed(bundle.getBundleId(), this.session)) continue;
                bundles.add(bundle);
            }
        }
        this.doExecute(bundles);
        return null;
    }

    protected abstract void doExecute(List<Bundle> var1) throws Exception;
}

