/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.karaf.admin.AdminService;
import org.apache.karaf.admin.Instance;
import org.apache.karaf.admin.InstanceSettings;
import org.apache.karaf.admin.internal.InstanceImpl;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminServiceImpl
implements AdminService {
    public static final String STORAGE_FILE = "instance.properties";
    private static final String FEATURES_CFG = "etc/org.apache.karaf.features.cfg";
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminServiceImpl.class);
    private Map<String, Instance> instances = new HashMap<String, Instance>();
    private int defaultPortStart = 8101;
    private File storageLocation;
    private long stopTimeout = 30000L;

    public File getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(File storage) {
        this.storageLocation = storage;
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(long stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadStorage(File location) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(location);
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStorage(Properties props, File location, String comment) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(location);
            props.store(os, comment);
        }
        finally {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
    }

    public synchronized void init() throws Exception {
        try {
            File storageFile = new File(this.storageLocation, STORAGE_FILE);
            if (!storageFile.isFile()) {
                if (storageFile.exists()) {
                    LOGGER.error("Instances storage location should be a file: " + storageFile);
                }
                return;
            }
            Properties storage = this.loadStorage(storageFile);
            int count = Integer.parseInt(storage.getProperty("count", "0"));
            this.defaultPortStart = Integer.parseInt(storage.getProperty("port", Integer.toString(this.defaultPortStart)));
            HashMap<String, Instance> newInstances = new HashMap<String, Instance>();
            for (int i = 0; i < count; ++i) {
                String name = storage.getProperty("item." + i + ".name", null);
                String loc = storage.getProperty("item." + i + ".loc", null);
                int pid = Integer.parseInt(storage.getProperty("item." + i + ".pid", "0"));
                boolean root = Boolean.parseBoolean(storage.getProperty("item." + i + ".root", "false"));
                if (name == null) continue;
                InstanceImpl instance = new InstanceImpl(this, name, loc, root);
                if (pid > 0) {
                    try {
                        instance.attach(pid);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                newInstances.put(name, instance);
            }
            this.instances = newInstances;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to reload Karaf instance list", (Throwable)e);
        }
    }

    @Override
    public synchronized Instance createInstance(String name, InstanceSettings settings) throws Exception {
        boolean cygwin;
        int sshPort;
        if (this.instances.get(name) != null) {
            throw new IllegalArgumentException("Instance '" + name + "' already exists");
        }
        String loc = settings.getLocation() != null ? settings.getLocation() : name;
        File karafBase = new File(loc);
        if (!karafBase.isAbsolute()) {
            karafBase = new File(this.storageLocation, loc);
        }
        if ((sshPort = settings.getPort()) <= 0) {
            sshPort = ++this.defaultPortStart;
        }
        this.println(Ansi.ansi().a("Creating new instance on port ").a(sshPort).a(" at: ").a(Ansi.Attribute.INTENSITY_BOLD).a((Object)karafBase).a(Ansi.Attribute.RESET).toString());
        this.mkdir(karafBase, "bin");
        this.mkdir(karafBase, "etc");
        this.mkdir(karafBase, "system");
        this.mkdir(karafBase, "deploy");
        this.mkdir(karafBase, "data");
        this.copyResourceToDir(karafBase, "etc/config.properties", true);
        this.copyResourceToDir(karafBase, "etc/jre.properties", true);
        this.copyResourceToDir(karafBase, "etc/custom.properties", true);
        this.copyResourceToDir(karafBase, "etc/java.util.logging.properties", true);
        this.copyResourceToDir(karafBase, "etc/org.apache.felix.fileinstall-deploy.cfg", true);
        this.copyResourceToDir(karafBase, "etc/org.apache.karaf.log.cfg", true);
        this.copyResourceToDir(karafBase, FEATURES_CFG, true);
        this.copyResourceToDir(karafBase, "etc/org.apache.karaf.management.cfg", true);
        this.copyResourceToDir(karafBase, "etc/org.ops4j.pax.logging.cfg", true);
        this.copyResourceToDir(karafBase, "etc/org.ops4j.pax.url.mvn.cfg", true);
        this.copyResourceToDir(karafBase, "etc/startup.properties", true);
        this.copyResourceToDir(karafBase, "etc/users.properties", true);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("${SUBST-KARAF-NAME}", name);
        props.put("${SUBST-KARAF-HOME}", System.getProperty("karaf.home"));
        props.put("${SUBST-KARAF-BASE}", karafBase.getPath());
        props.put("${SUBST-SSH-PORT}", Integer.toString(sshPort));
        this.copyFilteredResourceToDir(karafBase, "etc/system.properties", props);
        this.copyFilteredResourceToDir(karafBase, "etc/org.apache.karaf.shell.cfg", props);
        boolean windows = System.getProperty("os.name").startsWith("Win");
        boolean bl = cygwin = windows && new File(System.getProperty("karaf.home"), "bin/admin").exists();
        if (windows && !cygwin) {
            this.copyFilteredResourceToDir(karafBase, "bin/karaf.bat", props);
            this.copyFilteredResourceToDir(karafBase, "bin/start.bat", props);
            this.copyFilteredResourceToDir(karafBase, "bin/stop.bat", props);
        } else {
            this.copyFilteredResourceToDir(karafBase, "bin/karaf", props);
            this.copyFilteredResourceToDir(karafBase, "bin/start", props);
            this.copyFilteredResourceToDir(karafBase, "bin/stop", props);
            if (!cygwin) {
                this.chmod(new File(karafBase, "bin/karaf"), "a+x");
                this.chmod(new File(karafBase, "bin/start"), "a+x");
                this.chmod(new File(karafBase, "bin/stop"), "a+x");
            }
        }
        this.handleFeatures(new File(karafBase, FEATURES_CFG), settings);
        InstanceImpl instance = new InstanceImpl(this, name, karafBase.toString());
        this.instances.put(name, instance);
        this.saveState();
        return instance;
    }

    void handleFeatures(File featuresCfg, InstanceSettings settings) throws IOException {
        Properties p = this.loadStorage(featuresCfg);
        this.appendToPropList(p, "featuresBoot", settings.getFeatures());
        this.appendToPropList(p, "featuresRepositories", settings.getFeatureURLs());
        this.saveStorage(p, featuresCfg, "Features Configuration");
    }

    private void appendToPropList(Properties p, String key, List<String> elements) {
        if (elements == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(p.getProperty(key).trim());
        for (String f : elements) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f);
        }
        p.setProperty(key, sb.toString());
    }

    @Override
    public synchronized Instance[] getInstances() {
        return this.instances.values().toArray(new Instance[0]);
    }

    @Override
    public synchronized Instance getInstance(String name) {
        return this.instances.get(name);
    }

    synchronized void forget(String name) {
        this.instances.remove(name);
    }

    synchronized void saveState() throws IOException {
        Properties storage = new Properties();
        Instance[] data = this.getInstances();
        storage.setProperty("port", Integer.toString(this.defaultPortStart));
        storage.setProperty("count", Integer.toString(data.length));
        for (int i = 0; i < data.length; ++i) {
            storage.setProperty("item." + i + ".name", data[i].getName());
            storage.setProperty("item." + i + ".loc", data[i].getLocation());
            storage.setProperty("item." + i + ".pid", Integer.toString(data[i].getPid()));
        }
        this.saveStorage(storage, new File(this.storageLocation, STORAGE_FILE), "Admin Service storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceToDir(File target, String resource, boolean text) throws Exception {
        block13: {
            File outFile = new File(target, resource);
            if (!outFile.exists()) {
                this.println(Ansi.ansi().a("Creating file: ").a(Ansi.Attribute.INTENSITY_BOLD).a(outFile.getPath()).a(Ansi.Attribute.RESET).toString());
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/karaf/admin/" + resource);
                try {
                    if (text) {
                        PrintStream out = new PrintStream(new FileOutputStream(outFile));
                        try {
                            Scanner scanner = new Scanner(is);
                            while (scanner.hasNextLine()) {
                                String line = scanner.nextLine();
                                out.println(line);
                            }
                            break block13;
                        }
                        finally {
                            this.safeClose(out);
                        }
                    }
                    FileOutputStream out = new FileOutputStream(new File(target, resource));
                    try {
                        int c = 0;
                        while ((c = is.read()) >= 0) {
                            out.write(c);
                        }
                    }
                    finally {
                        this.safeClose(out);
                    }
                }
                finally {
                    this.safeClose(is);
                }
            }
        }
    }

    private void println(String st) {
        System.out.println(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFilteredResourceToDir(File target, String resource, HashMap<String, String> props) throws Exception {
        File outFile = new File(target, resource);
        if (!outFile.exists()) {
            this.println(Ansi.ansi().a("Creating file: ").a(Ansi.Attribute.INTENSITY_BOLD).a(outFile.getPath()).a(Ansi.Attribute.RESET).toString());
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/karaf/admin/" + resource);
            try {
                PrintStream out = new PrintStream(new FileOutputStream(outFile));
                try {
                    Scanner scanner = new Scanner(is);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        line = this.filter(line, props);
                        out.println(line);
                    }
                }
                finally {
                    this.safeClose(out);
                }
            }
            finally {
                this.safeClose(is);
            }
        }
    }

    private void safeClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String filter(String line, HashMap<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = line.indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = line.substring(0, p1);
            String l2 = line.substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    private void mkdir(File karafBase, String path) {
        File file = new File(karafBase, path);
        if (!file.exists()) {
            this.println(Ansi.ansi().a("Creating dir:  ").a(Ansi.Attribute.INTENSITY_BOLD).a(file.getPath()).a(Ansi.Attribute.RESET).toString());
            file.mkdirs();
        }
    }

    private int chmod(File serviceFile, String mode) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("chmod", mode, serviceFile.getCanonicalPath());
        Process p = builder.start();
        int status = p.waitFor();
        return status;
    }
}

