/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.agent.ChannelAgentForwarding;
import org.apache.sshd.client.SessionFactory;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.kex.DHG1;
import org.apache.sshd.client.kex.DHG14;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.compression.CompressionNone;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.common.random.BouncyCastleRandom;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureRSA;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.apache.sshd.common.util.SecurityUtils;

public class SshClient
extends AbstractFactoryManager {
    protected IoConnector connector;
    protected SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void start() {
        this.connector = new NioSocketConnector();
        SessionFactory handler = this.sessionFactory;
        if (handler == null) {
            handler = new SessionFactory();
        }
        handler.setClient(this);
        this.connector.setHandler((IoHandler)handler);
    }

    public void stop() {
        this.connector.dispose();
        this.connector = null;
    }

    public ConnectFuture connect(String host, int port) throws Exception {
        assert (host != null);
        assert (port >= 0);
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        InetSocketAddress address = new InetSocketAddress(host, port);
        return this.connect(address);
    }

    public ConnectFuture connect(SocketAddress address) throws Exception {
        assert (address != null);
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        final DefaultConnectFuture connectFuture = new DefaultConnectFuture(null);
        this.connector.connect(address).addListener((IoFutureListener)new IoFutureListener<org.apache.mina.core.future.ConnectFuture>(){

            public void operationComplete(org.apache.mina.core.future.ConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                } else if (future.getException() != null) {
                    connectFuture.setException(future.getException());
                } else {
                    ClientSessionImpl session = (ClientSessionImpl)AbstractSession.getSession(future.getSession());
                    connectFuture.setSession(session);
                }
            }
        });
        return connectFuture;
    }

    public static SshClient setUpDefaultClient() {
        SshClient client = new SshClient();
        if (SecurityUtils.isBouncyCastleRegistered()) {
            client.setKeyExchangeFactories(Arrays.asList(new DHG14.Factory(), new DHG1.Factory()));
            client.setRandomFactory(new SingletonRandomFactory(new BouncyCastleRandom.Factory()));
        } else {
            client.setKeyExchangeFactories(Arrays.asList(new DHG1.Factory()));
            client.setRandomFactory(new SingletonRandomFactory(new JceRandom.Factory()));
        }
        SshClient.setUpDefaultCiphers(client);
        client.setCompressionFactories(Arrays.asList(new CompressionNone.Factory()));
        client.setMacFactories(Arrays.asList(new HMACMD5.Factory(), new HMACSHA1.Factory(), new HMACMD596.Factory(), new HMACSHA196.Factory()));
        client.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory()));
        client.setChannelFactories(Arrays.asList(new ChannelAgentForwarding.Factory()));
        return client;
    }

    private static void setUpDefaultCiphers(SshClient client) {
        LinkedList<NamedFactory<Cipher>> avail = new LinkedList<NamedFactory<Cipher>>();
        avail.add(new AES128CBC.Factory());
        avail.add(new TripleDESCBC.Factory());
        avail.add(new BlowfishCBC.Factory());
        avail.add(new AES192CBC.Factory());
        avail.add(new AES256CBC.Factory());
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            NamedFactory f = (NamedFactory)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                i.remove();
            }
            catch (Exception e) {
                i.remove();
            }
        }
        client.setCipherFactories(avail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int port = 22;
        String host = null;
        String login = System.getProperty("user.name");
        boolean agentForward = false;
        ArrayList<String> command = null;
        int logLevel = 0;
        boolean error = false;
        for (int i = 0; i < args.length; ++i) {
            if (command == null && "-p".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    error = true;
                    break;
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (command == null && "-l".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    error = true;
                    break;
                }
                login = args[++i];
                continue;
            }
            if (command == null && "-v".equals(args[i])) {
                logLevel = 1;
                continue;
            }
            if (command == null && "-vv".equals(args[i])) {
                logLevel = 2;
                continue;
            }
            if (command == null && "-vvv".equals(args[i])) {
                logLevel = 3;
                continue;
            }
            if ("-A".equals(args[i])) {
                agentForward = true;
                continue;
            }
            if ("-a".equals(args[i])) {
                agentForward = false;
                continue;
            }
            if (command == null && args[i].startsWith("-")) {
                System.err.println("illegal option: " + args[i]);
                error = true;
                break;
            }
            if (host == null) {
                host = args[i];
                continue;
            }
            if (command == null) {
                command = new ArrayList<String>();
            }
            command.add(args[i]);
        }
        if (host == null) {
            System.err.println("hostname required");
            error = true;
        }
        if (error) {
            System.err.println("usage: ssh [-A|-a] [-v[v][v]] [-l login] [-p port] hostname [command]");
            System.exit(-1);
        }
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        try {
            ClientChannel channel;
            boolean hasKeys = false;
            ClientSession session = ((ConnectFuture)client.connect(host, port).await()).getSession();
            int ret = 4;
            while ((ret & 4) != 0) {
                if (hasKeys) {
                    session.authAgent(login);
                    ret = session.waitFor(14, 0L);
                    continue;
                }
                System.out.print("Password:");
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                String password = r.readLine();
                session.authPassword(login, password);
                ret = session.waitFor(14, 0L);
            }
            if ((ret & 2) != 0) {
                System.err.println("error");
                System.exit(-1);
            }
            if (command == null) {
                channel = session.createChannel("shell");
                ((ChannelShell)channel).setAgentForwarding(agentForward);
                channel.setIn(new NoCloseInputStream(System.in));
            } else {
                channel = session.createChannel("exec");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStreamWriter w = new OutputStreamWriter(baos);
                for (String cmd : command) {
                    ((Writer)w).append(cmd).append(" ");
                }
                ((Writer)w).append("\n");
                ((Writer)w).close();
                channel.setIn(new ByteArrayInputStream(baos.toByteArray()));
            }
            channel.setOut(new NoCloseOutputStream(System.out));
            channel.setErr(new NoCloseOutputStream(System.err));
            channel.open().await();
            channel.waitFor(2, 0L);
            session.close(false);
        }
        finally {
            client.stop();
        }
    }
}

