/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.LinkedList;
import org.apache.felix.cm.impl.ConfigurationManager;

public class UpdateThread
implements Runnable {
    private final ConfigurationManager configurationManager;
    private final ThreadGroup workerThreadGroup;
    private final String workerBaseName;
    private final LinkedList updateTasks;
    private Thread worker;

    public UpdateThread(ConfigurationManager configurationManager, ThreadGroup tg, String name) {
        this.configurationManager = configurationManager;
        this.workerThreadGroup = tg;
        this.workerBaseName = name;
        this.updateTasks = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Runnable task;
            LinkedList linkedList = this.updateTasks;
            synchronized (linkedList) {
                while (this.updateTasks.isEmpty()) {
                    try {
                        this.updateTasks.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                task = (Runnable)this.updateTasks.removeFirst();
            }
            if (task == this) {
                return;
            }
            try {
                Thread.currentThread().setName(this.workerBaseName + " (" + task + ")");
                if (this.configurationManager.isLogEnabled(4)) {
                    this.configurationManager.log(4, "Running task " + task, null);
                }
                task.run();
                continue;
            }
            catch (Throwable t) {
                this.configurationManager.log(1, "Unexpected problem executing task", t);
                continue;
            }
            finally {
                Thread.currentThread().setName(this.workerBaseName);
                continue;
            }
            break;
        }
    }

    synchronized void start() {
        if (this.worker == null) {
            Thread workerThread = new Thread(this.workerThreadGroup, this, this.workerBaseName);
            workerThread.setDaemon(true);
            workerThread.start();
            this.worker = workerThread;
        }
    }

    synchronized void terminate() {
        if (this.worker != null) {
            Thread workerThread = this.worker;
            this.worker = null;
            this.schedule(this);
            try {
                workerThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (workerThread.isAlive()) {
                this.configurationManager.log(1, "Worker thread " + this.workerBaseName + " did not terminate within 5 seconds; trying to kill", null);
                workerThread.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable update) {
        LinkedList linkedList = this.updateTasks;
        synchronized (linkedList) {
            if (this.configurationManager.isLogEnabled(4)) {
                this.configurationManager.log(4, "Scheduling task " + update, null);
            }
            this.updateTasks.add(update);
            this.updateTasks.notifyAll();
        }
    }
}

