/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.packages;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.packages.PackageCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="packages", name="exports", description="Displays exported packages.")
public class ExportsCommand
extends PackageCommandSupport {
    @Option(name="-i", aliases={"--imports"}, description="List bundles importing the specified packages")
    boolean imports;
    @Option(name="-s", description="Shows the symbolic name", required=false, multiValued=false)
    boolean showSymbolic;
    @Option(name="-d", aliases={"--details"}, description="List bundles in a master detail table")
    boolean details;
    @Argument(index=0, name="ids", description="The IDs of bundles to check", required=false, multiValued=true)
    List<Long> ids;

    @Override
    protected void doExecute(PackageAdmin admin) throws Exception {
        String format = "";
        int index = 1;
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("ID");
        format = format + "%" + index++ + "$6s";
        if (this.showSymbolic) {
            headers.add("Symbolic name");
            format = format + " %" + index++ + "$-40s ";
        }
        headers.add("Packages");
        format = format + " %" + index++ + "$-40s";
        if (this.imports) {
            headers.add("Imported by");
            format = format + " %" + index++ + "$-40s";
        }
        format = format + "\n";
        System.out.format(format, headers.toArray());
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle != null) {
                    this.printExports(System.out, format, bundle, admin.getExportedPackages(bundle));
                    continue;
                }
                System.err.println("Bundle ID " + id + " is invalid.");
            }
        } else {
            for (Bundle bundle : this.getBundleContext().getBundles()) {
                this.printExports(System.out, format, bundle, admin.getExportedPackages(bundle));
            }
        }
    }

    protected void printExports(PrintStream out, String format, Bundle target, ExportedPackage[] exports) {
        ArrayList<String> columns = new ArrayList<String>();
        if (exports != null && exports.length > 0) {
            for (int i = 0; i < exports.length; ++i) {
                columns = new ArrayList();
                Bundle bundle = exports[i].getExportingBundle();
                columns.add(String.valueOf(bundle.getBundleId()));
                if (this.showSymbolic) {
                    columns.add(bundle.getSymbolicName());
                }
                if (i > 0) {
                    int size = columns.size();
                    if (this.details) {
                        columns = new ArrayList();
                        this.fillDetailRecord(columns, size);
                    }
                }
                columns.add(exports[i].toString());
                if (this.imports) {
                    Bundle[] bs = exports[i].getImportingBundles();
                    if (bs != null && bs.length > 0) {
                        for (int j = 0; j < bs.length; ++j) {
                            columns.add(ExportsCommand.getBundleName(bs[j]));
                            out.format(format, columns.toArray());
                            if (this.details) {
                                int size = columns.size();
                                columns = new ArrayList();
                                this.fillDetailRecord(columns, size - 1);
                                continue;
                            }
                            columns.remove(columns.size() - 1);
                        }
                        continue;
                    }
                    columns.add("");
                    out.format(format, columns.toArray());
                    continue;
                }
                out.format(format, columns.toArray());
            }
        } else {
            columns.add(String.valueOf(target.getBundleId()));
            if (this.showSymbolic) {
                columns.add(target.getSymbolicName());
            }
            columns.add("No active exported packages.");
            if (this.imports) {
                columns.add("");
            }
            out.format(format, columns.toArray());
        }
    }

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }

    public void fillDetailRecord(List<String> colums, int size) {
        for (int i = 0; i < size; ++i) {
            colums.add("");
        }
    }
}

