/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.InvocationHandlerWrapper;
import org.apache.aries.proxy.impl.AbstractProxyManager;
import org.apache.aries.proxy.impl.DefaultWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyHandler
implements InvocationHandler {
    private final Callable<Object> target;
    private final InvocationHandler core;
    private final InvocationHandlerWrapper wrapper;
    private final AbstractProxyManager proxyManager;

    public ProxyHandler(AbstractProxyManager abstractProxyManager, Callable<Object> dispatcher, InvocationHandlerWrapper wrapper) {
        this.target = dispatcher;
        this.proxyManager = abstractProxyManager;
        this.wrapper = wrapper == null ? new DefaultWrapper() : wrapper;
        this.core = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result;
                try {
                    result = method.invoke(ProxyHandler.this.target.call(), args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getCause();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                return result;
            }
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals") && method.getDeclaringClass() == Object.class) {
            Object targetObject = args[0];
            if (this.proxyManager.isProxy(targetObject)) {
                args[0] = this.proxyManager.unwrap(targetObject).call();
            }
        } else if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
            return null;
        }
        return this.wrapper.invoke(proxy, method, args, this.core);
    }

    public Callable<Object> getTarget() {
        return this.target;
    }
}

