/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.io.IOException;
import org.apache.felix.service.command.CommandSession;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public class Util {
    private static StringBuffer m_sb = new StringBuffer();

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnderlineString(String s) {
        StringBuffer stringBuffer = m_sb;
        synchronized (stringBuffer) {
            m_sb.delete(0, m_sb.length());
            for (int i = 0; i < s.length(); ++i) {
                m_sb.append('-');
            }
            return m_sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValueString(Object obj) {
        StringBuffer stringBuffer = m_sb;
        synchronized (stringBuffer) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof String[]) {
                String[] array = (String[])obj;
                m_sb.delete(0, m_sb.length());
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        m_sb.append(", ");
                    }
                    m_sb.append(array[i].toString());
                }
                return m_sb.toString();
            }
            if (obj instanceof Boolean) {
                return ((Boolean)obj).toString();
            }
            if (obj instanceof Long) {
                return ((Long)obj).toString();
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).toString();
            }
            if (obj instanceof Short) {
                return ((Short)obj).toString();
            }
            if (obj instanceof Double) {
                return ((Double)obj).toString();
            }
            if (obj instanceof Float) {
                return ((Float)obj).toString();
            }
            if (obj == null) {
                return "null";
            }
            return obj.toString();
        }
    }

    public static boolean isASystemBundle(BundleContext bundleContext, Bundle bundle) {
        StartLevel sl;
        ServiceReference ref = bundleContext.getServiceReference(StartLevel.class.getName());
        if (ref != null && (sl = (StartLevel)bundleContext.getService(ref)) != null) {
            int level = sl.getBundleStartLevel(bundle);
            int sbsl = 49;
            String sbslProp = bundleContext.getProperty("karaf.systemBundlesStartLevel");
            if (sbslProp != null) {
                try {
                    sbsl = Integer.valueOf(sbslProp);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            return level <= sbsl;
        }
        return false;
    }

    public static boolean accessToSystemBundleIsAllowed(long bundleId, CommandSession session) throws IOException {
        String str;
        do {
            StringBuffer sb = new StringBuffer();
            System.err.print("You are about to access system bundle " + bundleId + ".  Do you want to continue (yes/no): ");
            System.err.flush();
            while (true) {
                int c;
                if ((c = session.getKeyboard().read()) < 0) {
                    return false;
                }
                System.err.print((char)c);
                if (c == 13 || c == 10) break;
                sb.append((char)c);
            }
            str = sb.toString();
            if (!"yes".equals(str)) continue;
            return true;
        } while (!"no".equals(str));
        return false;
    }
}

