/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="edit", description="Creates or edits a configuration.", detailedDescription="classpath:edit.txt")
public class EditCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="pid", description="PID of the configuration", required=true, multiValued=false)
    String pid;
    @Option(name="--force", aliases={}, description="Force the edition of this config, even if another one was under edition", required=false, multiValued=false)
    boolean force;
    @Option(name="-f", aliases={"--use-file"}, description="Configuration lookup using the filename instead of the pid", required=false, multiValued=false)
    boolean useFile;

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Dictionary props;
        String oldPid = (String)this.session.get("ConfigCommand.PID");
        if (oldPid != null && !oldPid.equals(this.pid) && !this.force) {
            System.err.println("Another config is being edited.  Cancel / update first, or use the --force option");
            return;
        }
        if (this.useFile) {
            Configuration configuration = this.findConfigurationByFileName(admin, this.pid);
            if (configuration == null) {
                System.err.println("Could not find configuration with file install property set to: " + this.pid);
                return;
            }
            props = configuration.getProperties();
            this.pid = configuration.getPid();
        } else {
            Configuration configuration = admin.getConfiguration(this.pid, null);
            props = configuration.getProperties();
            if (props == null) {
                props = new Properties();
            }
        }
        this.session.put("ConfigCommand.PID", (Object)this.pid);
        this.session.put("ConfigCommand.Props", (Object)props);
    }
}

