/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.lang.reflect.Method;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class BundleHelper {
    private static final SecurityManagerEx securityManager = new SecurityManagerEx();
    private static final Method getBundleMethod;

    private BundleHelper() {
    }

    public static Bundle getCallerBundle(Bundle defaultBundle) {
        if (getBundleMethod != null) {
            try {
                Class[] classCtx = new SecurityManagerEx().getClassContext();
                Bundle curBundle = null;
                for (int i = 0; i < classCtx.length; ++i) {
                    Bundle bundle = (Bundle)getBundleMethod.invoke(null, classCtx[i]);
                    if (bundle == null) {
                        return defaultBundle;
                    }
                    if (curBundle == null) {
                        curBundle = bundle;
                        continue;
                    }
                    if (bundle == curBundle) continue;
                    return bundle;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultBundle;
    }

    static {
        Method mth = null;
        try {
            mth = FrameworkUtil.class.getMethod("getBundle", Class.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getBundleMethod = mth;
    }

    static class SecurityManagerEx
    extends SecurityManager {
        SecurityManagerEx() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

