/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.framework.internal.core.ConsoleManager;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class EquinoxLauncher
implements org.osgi.framework.launch.Framework {
    private volatile Framework framework;
    private volatile Bundle systemBundle;
    private final Map configuration;
    private volatile ConsoleManager consoleMgr = null;

    public EquinoxLauncher(Map configuration) {
        this.configuration = configuration;
    }

    public void init() {
        this.checkAdminPermission("execute");
        if (System.getSecurityManager() == null) {
            this.internalInit();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    EquinoxLauncher.this.internalInit();
                    return null;
                }
            });
        }
    }

    synchronized Framework internalInit() {
        if ((this.getState() & 0x38) != 0) {
            return this.framework;
        }
        if (System.getSecurityManager() != null && this.configuration.get("org.osgi.framework.security") != null) {
            throw new SecurityException("Cannot specify the \"org.osgi.framework.security\" configuration property when a security manager is already installed.");
        }
        Framework current = this.framework;
        if (current != null) {
            current.close();
            this.framework = null;
            this.systemBundle = null;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            FrameworkProperties.setProperties(this.configuration);
            FrameworkProperties.initializeProperties();
            this.setEquinoxProperties(this.configuration);
            current = new Framework(new BaseAdaptor(new String[0]));
            this.consoleMgr = ConsoleManager.startConsole(current);
            current.launch();
            this.framework = current;
            this.systemBundle = current.systemBundle;
        }
        finally {
            ClassLoader currentCCL = Thread.currentThread().getContextClassLoader();
            if (currentCCL != tccl) {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return current;
    }

    private void setEquinoxProperties(Map configuration) {
        Object parentCL;
        Object clean;
        Object storage;
        String windowSystem;
        Object threadBehavior;
        Object v0 = threadBehavior = configuration == null ? null : configuration.get("osgi.framework.activeThreadType");
        if (threadBehavior == null) {
            if (FrameworkProperties.getProperty("osgi.framework.activeThreadType") == null) {
                FrameworkProperties.setProperty("osgi.framework.activeThreadType", "normal");
            }
        } else {
            FrameworkProperties.setProperty("osgi.framework.activeThreadType", threadBehavior);
        }
        String string = windowSystem = configuration == null ? null : (String)configuration.get("org.osgi.framework.windowsystem");
        if (windowSystem == null && (windowSystem = FrameworkProperties.getProperty("osgi.ws")) != null) {
            FrameworkProperties.setProperty("org.osgi.framework.windowsystem", windowSystem);
        }
        if (configuration == null) {
            return;
        }
        Object security = configuration.get("org.osgi.framework.security");
        if (security != null) {
            if ("osgi".equals(security)) {
                FrameworkProperties.setProperty("eclipse.security", "osgi");
            } else if (security instanceof String) {
                FrameworkProperties.setProperty("eclipse.security", (String)security);
            }
        }
        if ((storage = configuration.get("org.osgi.framework.storage")) != null && storage instanceof String) {
            FrameworkProperties.setProperty("osgi.configuration.area", (String)storage);
        }
        if ("onFirstInit".equals(clean = configuration.get("org.osgi.framework.storage.clean"))) {
            configuration.remove("org.osgi.framework.storage.clean");
            FrameworkProperties.setProperty("osgi.clean", Boolean.TRUE.toString());
        }
        if ("framework".equals(parentCL = configuration.get("org.osgi.framework.bundle.parent"))) {
            parentCL = "fwk";
        }
        if (parentCL instanceof String) {
            FrameworkProperties.setProperty("osgi.parentClassloader", (String)parentCL);
        }
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        Framework current = this.framework;
        if (current == null) {
            return new FrameworkEvent(64, this, null);
        }
        return current.waitForStop(timeout);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getBundleContext();
    }

    public long getBundleId() {
        return 0L;
    }

    public URL getEntry(String path) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getEntry(path);
    }

    public Enumeration getEntryPaths(String path) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getEntryPaths(path);
    }

    public Dictionary getHeaders() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getHeaders();
    }

    public Dictionary getHeaders(String locale) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getHeaders(locale);
    }

    public long getLastModified() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return System.currentTimeMillis();
        }
        return current.getLastModified();
    }

    public String getLocation() {
        return "System Bundle";
    }

    public ServiceReference[] getRegisteredServices() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getRegisteredServices();
    }

    public URL getResource(String name) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getResources(name);
    }

    public ServiceReference[] getServicesInUse() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.getServicesInUse();
    }

    public int getState() {
        Bundle current = this.systemBundle;
        if (current == null) {
            return 2;
        }
        return current.getState();
    }

    public String getSymbolicName() {
        return "org.eclipse.osgi";
    }

    public boolean hasPermission(Object permission) {
        Bundle current = this.systemBundle;
        if (current == null) {
            return false;
        }
        return current.hasPermission(permission);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Bundle current = this.systemBundle;
        if (current == null) {
            return null;
        }
        return current.loadClass(name);
    }

    public void start(int options) throws BundleException {
        this.start();
    }

    public void start() throws BundleException {
        this.checkAdminPermission("execute");
        if (System.getSecurityManager() == null) {
            this.internalStart();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws BundleException {
                        EquinoxLauncher.this.internalStart();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (BundleException)e.getException();
            }
        }
    }

    private void checkAdminPermission(String actions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, actions));
        }
    }

    void internalStart() throws BundleException {
        if (this.getState() == 32) {
            return;
        }
        Framework current = this.internalInit();
        int level = 1;
        try {
            level = Integer.parseInt((String)this.configuration.get("org.osgi.framework.startlevel.beginning"));
        }
        catch (Throwable throwable) {}
        current.startLevelManager.doSetStartLevel(level);
    }

    public void stop(int options) throws BundleException {
        this.stop();
    }

    public void stop() throws BundleException {
        Bundle current = this.systemBundle;
        if (current == null) {
            return;
        }
        ConsoleManager currentConsole = this.consoleMgr;
        if (currentConsole != null) {
            currentConsole.stopConsole();
            this.consoleMgr = null;
        }
        current.stop();
    }

    public void uninstall() throws BundleException {
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION, 2);
    }

    public void update() throws BundleException {
        Bundle current = this.systemBundle;
        if (current == null) {
            return;
        }
        current.update();
    }

    public void update(InputStream in) throws BundleException {
        try {
            in.close();
        }
        catch (IOException iOException) {}
        this.update();
    }

    public Map getSignerCertificates(int signersType) {
        Bundle current = this.systemBundle;
        if (current != null) {
            return current.getSignerCertificates(signersType);
        }
        return Collections.EMPTY_MAP;
    }

    public Version getVersion() {
        Bundle current = this.systemBundle;
        if (current != null) {
            current.getVersion();
        }
        return Version.emptyVersion;
    }
}

