/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class Util {
    private static final String CHECKSUM_SUFFIX = ".checksum";
    private static Logger logger;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public static int getGlobalLogLevel(BundleContext context) {
        String s = context.getProperty("felix.fileinstall.log.level");
        s = s == null ? System.getProperty("felix.fileinstall.log.level".toUpperCase().replace('.', '_')) : s;
        s = s == null ? "1" : s;
        int logLevel = 1;
        try {
            logLevel = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return logLevel;
    }

    public static void log(BundleContext context, int logLevel, int msgLevel, String message, Throwable e) {
        Util.getLogger(context).log(logLevel, msgLevel, message, e);
    }

    private static Logger getLogger(BundleContext context) {
        try {
            context.getBundle();
            if (logger != null && logger.isValidLogger(context)) {
                return logger;
            }
            logger = new OsgiLogger(context);
        }
        catch (Throwable t) {
            logger = new StdOutLogger();
        }
        return logger;
    }

    public static void jarDir(File directory, File zipName) throws IOException {
        Util.jarDir(directory, new BufferedOutputStream(new FileOutputStream(zipName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jarDir(File directory, OutputStream os) throws IOException {
        JarOutputStream zos = new JarOutputStream(os);
        zos.setLevel(0);
        String path = "";
        File manFile = new File(directory, "META-INF/MANIFEST.MF");
        if (manFile.exists()) {
            byte[] readBuffer = new byte[8192];
            FileInputStream fis = new FileInputStream(manFile);
            try {
                ZipEntry anEntry = new ZipEntry("META-INF/MANIFEST.MF");
                zos.putNextEntry(anEntry);
                int bytesIn = fis.read(readBuffer);
                while (bytesIn != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                    bytesIn = fis.read(readBuffer);
                }
            }
            finally {
                fis.close();
            }
            zos.closeEntry();
        }
        Util.zipDir(directory, zos, path, Collections.singleton("META-INF/MANIFEST.MF"));
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File directory, ZipOutputStream zos, String path, Set exclusions) throws IOException {
        File[] dirList = directory.listFiles();
        byte[] readBuffer = new byte[8192];
        int bytesIn = 0;
        for (int i = 0; i < dirList.length; ++i) {
            File f = dirList[i];
            if (f.isDirectory()) {
                String prefix = path + f.getName() + "/";
                zos.putNextEntry(new ZipEntry(prefix));
                Util.zipDir(f, zos, prefix, exclusions);
                continue;
            }
            String entry = path + f.getName();
            if (exclusions.contains(entry)) continue;
            FileInputStream fis = new FileInputStream(f);
            try {
                ZipEntry anEntry = new ZipEntry(entry);
                zos.putNextEntry(anEntry);
                bytesIn = fis.read(readBuffer);
                while (bytesIn != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                    bytesIn = fis.read(readBuffer);
                }
                continue;
            }
            finally {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeChecksum(Bundle b, long checksum, BundleContext bc) {
        String key = Util.getBundleKey(b);
        File f = bc.getDataFile(key + CHECKSUM_SUFFIX);
        FilterOutputStream dout = null;
        try {
            dout = new DataOutputStream(new FileOutputStream(f));
            ((DataOutputStream)dout).writeLong(checksum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dout != null) {
                try {
                    dout.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long loadChecksum(Bundle b, BundleContext bc) {
        String key = Util.getBundleKey(b);
        File f = bc.getDataFile(key + CHECKSUM_SUFFIX);
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(f));
            long l = ((DataInputStream)in).readLong();
            return l;
        }
        catch (Exception e) {
            long l = Long.MIN_VALUE;
            return l;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String getBundleKey(Bundle b) {
        return Long.toString(b.getBundleId());
    }

    static class OsgiLogger
    extends StdOutLogger {
        private BundleContext context;

        OsgiLogger(BundleContext context) {
            this.context = context;
            try {
                this.getClass().getClassLoader().loadClass((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Util.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }

        public boolean isValidLogger(BundleContext context) {
            return context == this.context;
        }

        public void log(int logLevel, int msgLevel, String message, Throwable throwable) {
            if (logLevel > 0 && msgLevel <= logLevel) {
                LogService log = this.getLogService();
                if (log != null) {
                    log.log(msgLevel, message, throwable);
                } else {
                    super.log(logLevel, msgLevel, message, throwable);
                }
            }
        }

        private LogService getLogService() {
            ServiceReference ref = this.context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Util.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            if (ref != null) {
                LogService log = (LogService)this.context.getService(ref);
                return log;
            }
            return null;
        }
    }

    static class StdOutLogger
    implements Logger {
        StdOutLogger() {
        }

        public boolean isValidLogger(BundleContext context) {
            return true;
        }

        public void log(int logLevel, int msgLevel, String message, Throwable throwable) {
            if (logLevel > 0 && msgLevel <= logLevel) {
                System.out.println(message + (throwable == null ? "" : ": " + throwable));
                if (throwable != null) {
                    throwable.printStackTrace(System.out);
                }
            }
        }
    }

    static interface Logger {
        public static final int LOG_ERROR = 1;
        public static final int LOG_WARNING = 2;
        public static final int LOG_INFO = 3;
        public static final int LOG_DEBUG = 4;

        public boolean isValidLogger(BundleContext var1);

        public void log(int var1, int var2, String var3, Throwable var4);
    }
}

